/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.file;

import cn.hutool.core.util.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadSimple {
    private static final Logger log = LoggerFactory.getLogger(FileUploadSimple.class);

    public static void transferTo(MultipartFile fileData, String realPath) {
        if (!Files.exists(new File(realPath).toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(new File(realPath).toPath(), new FileAttribute[0]);
                fileData.transferTo(new File(realPath));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String getNumberName(String fileName, String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return FileUploadSimple.getNewFileName(fileName, numberName, defalutExds);
    }

    public static String getDataPath() {
        return new SimpleDateFormat("yyyyMM").format(new Date());
    }

    public static String getNumberName(String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return numberName + "." + defalutExds;
    }

    public static String getNumberFile() {
        return new SimpleDateFormat("HHmmss").format(new Date()) + RandomUtil.randomNumbers((int)2);
    }

    public static String getNewFileName(String fileName, String newName, String nullSuffix) {
        String suffix = FilenameUtils.getExtension((String)fileName);
        newName = suffix != null ? newName.concat(".").concat(suffix) : newName.concat(".").concat(nullSuffix);
        return newName;
    }
}

