/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.excel;

import cn.smarthse.common.framework.excel.ExportListVO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportListExcel {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;
    private HSSFDataFormat format = null;
    private HSSFRow hdRow = null;
    private int rowCounts = 1;
    List<String> headers = new ArrayList<String>();
    List<String> fieldNames = new ArrayList<String>();
    List<Integer> mergeList = new ArrayList<Integer>();
    private boolean autoMerge = true;
    private boolean isFilter = true;

    public ExportListExcel(String[] colums) {
        this.wb = new HSSFWorkbook();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            this.headers.add(t[0]);
            this.fieldNames.add(t[1]);
        }
    }

    public void createSheet(String sheetName) {
        this.sheet = this.wb.createSheet(sheetName);
        this.format = this.wb.createDataFormat();
        this.hdRow = this.sheet.createRow(0);
        this.addHeader();
    }

    public void addHeader() {
        int i = 0;
        for (String title : this.headers) {
            HSSFCell cell1 = this.hdRow.createCell(i++);
            HSSFRichTextString value = new HSSFRichTextString(title);
            cell1.setCellValue((RichTextString)value);
            if (!this.isFilter) continue;
            HSSFFont workFont = this.wb.createFont();
            workFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            workFont.setFontHeightInPoints((short)12);
            workFont.setBold(true);
            HSSFCellStyle hdStyle = this.wb.createCellStyle();
            hdStyle.setBorderBottom(BorderStyle.THIN);
            hdStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            hdStyle.setBorderLeft(BorderStyle.THIN);
            hdStyle.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            hdStyle.setBorderRight(BorderStyle.THIN);
            hdStyle.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            hdStyle.setBorderTop(BorderStyle.THIN);
            hdStyle.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            hdStyle.setAlignment(HorizontalAlignment.CENTER);
            hdStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            hdStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            hdStyle.setBorderBottom(BorderStyle.THIN);
            hdStyle.setFont(workFont);
            cell1.setCellStyle(hdStyle);
        }
    }

    public void addRows(List<ExportListVO> list) {
        for (ExportListVO vo : list) {
            this.vo2filevalue(vo);
        }
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            this.sheet.autoSizeColumn((int)((short)i));
        }
    }

    private void vo2filevalue(ExportListVO vo) {
        if (vo != null) {
            if (vo.getChilds() == null || vo.getChilds().size() == 0) {
                this.addRow(this.add2fieldvalue(vo.getParent(), null));
                return;
            }
            if (vo.getChilds().size() == 1) {
                this.addRow(this.add2fieldvalue(vo.getParent(), vo.getChilds().get(0)));
                return;
            }
            ArrayList<HSSFRow> mr_List = new ArrayList<HSSFRow>();
            for (Object child : vo.getChilds()) {
                HSSFRow raw = this.addRow(this.add2fieldvalue(vo.getParent(), child));
                mr_List.add(raw);
            }
            if (mr_List.size() > 0 && this.autoMerge) {
                HSSFRow firstRow = (HSSFRow)mr_List.get(0);
                HSSFRow endRow = (HSSFRow)mr_List.get(mr_List.size() - 1);
                for (int index : this.mergeList) {
                    this.addMergedRegion2(index, firstRow, endRow);
                }
            }
        }
    }

    private void addMergedRegion2(int colIndex, HSSFRow firstRow, HSSFRow endRow) {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        String s_will = firstRow.getCell(colIndex).getStringCellValue();
        String s_current = endRow.getCell(colIndex).getStringCellValue();
        if (s_will.equals(s_current)) {
            this.sheet.addMergedRegion(new CellRangeAddress(firstRow.getRowNum(), endRow.getRowNum(), colIndex, colIndex));
            HSSFCell cell = firstRow.createCell(0);
            cell.setCellValue(s_will);
            cell.setCellStyle(style);
        }
    }

    private HSSFRow addRow(Object[] values) {
        HSSFRow dtRow = this.sheet.createRow(this.rowCounts++);
        for (int i = 0; i < values.length; ++i) {
            HSSFCell cell = dtRow.createCell((int)((short)i));
            this.setCellValue(values[i], cell);
        }
        return dtRow;
    }

    private Object[] add2fieldvalue(Object parent, Object child) {
        Object[] values = new Object[this.fieldNames.size()];
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            Object fieldValue;
            String field = this.fieldNames.get(i);
            String fieldKEY = field.substring(0, 2);
            String fieldName = field.substring(2);
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if ("p_".equals(fieldKEY) && parent != null) {
                fieldValue = this.getObjectMethodValue(parent, getMethodName);
                if (fieldValue != null) {
                    values[i] = fieldValue;
                    continue;
                }
                values[i] = "";
                continue;
            }
            if (!"c_".equals(fieldKEY) || child == null) continue;
            fieldValue = this.getObjectMethodValue(child, getMethodName);
            values[i] = fieldValue != null ? fieldValue : "";
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getObjectMethodValue(Object obj, String methodName) {
        if (obj == null) {
            return null;
        }
        try {
            Class<?> tCls = obj.getClass();
            Method getMethod = tCls.getMethod(methodName, new Class[0]);
            return getMethod.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCellValue(Object value, HSSFCell cell) {
        block17: {
            if (value == null) {
                cell.setCellValue("");
                return;
            }
            try {
                String textValue = null;
                if (value instanceof Integer) {
                    int intValue = (Integer)value;
                    cell.setCellValue((double)intValue);
                } else if (value instanceof Float) {
                    float fValue = ((Float)value).floatValue();
                    HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                    cell.setCellValue((RichTextString)richText);
                } else if (value instanceof Double) {
                    double dValue = (Double)value;
                    HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                    cell.setCellValue((RichTextString)richText);
                } else if (value instanceof Long) {
                    long longValue = (Long)value;
                    cell.setCellValue((double)longValue);
                } else if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    textValue = sdf.format(date);
                } else {
                    textValue = value.toString();
                }
                if (textValue == null) break block17;
                Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                Matcher matcher = p.matcher(textValue);
                if (matcher.matches()) {
                    cell.setCellValue(Double.parseDouble(textValue));
                    break block17;
                }
                cell.setCellValue(textValue);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private void addMergedRegion(int cellLine, int startRow, int endRow) {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        String s_will = this.sheet.getRow(startRow).getCell(cellLine).getStringCellValue();
        int count = 0;
        boolean flag = false;
        for (int i = startRow; i <= endRow; ++i) {
            String s_current = this.sheet.getRow(i).getCell(cellLine).getStringCellValue();
            if (s_will.equals(s_current)) {
                ++count;
            } else {
                flag = true;
            }
            if (flag && count > 0) {
                this.sheet.addMergedRegion(new CellRangeAddress(startRow, i, cellLine, cellLine));
                HSSFRow row = this.sheet.getRow(startRow);
                HSSFCell cell = row.createCell(0);
                cell.setCellValue(s_will);
                cell.setCellStyle(style);
                s_will = s_current;
                count = 0;
                flag = false;
                startRow = i + 1;
                continue;
            }
            s_will = s_current;
        }
    }

    public void exportExcel(String file) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(FileUtils.getFile((String[])new String[]{file}));
        this.wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public void exportExcel(File file) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(file);
        this.wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public void exportExcel(OutputStream outputstream) {
        try {
            this.wb.write(outputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.wb.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addMergeCol(int i) {
        this.mergeList.add(i);
    }

    public HSSFWorkbook getWb() {
        return this.wb;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public HSSFDataFormat getFormat() {
        return this.format;
    }

    public HSSFRow getHdRow() {
        return this.hdRow;
    }

    public int getRowCounts() {
        return this.rowCounts;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<Integer> getMergeList() {
        return this.mergeList;
    }

    public boolean isAutoMerge() {
        return this.autoMerge;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public void setFormat(HSSFDataFormat format) {
        this.format = format;
    }

    public void setHdRow(HSSFRow hdRow) {
        this.hdRow = hdRow;
    }

    public void setRowCounts(int rowCounts) {
        this.rowCounts = rowCounts;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setMergeList(List<Integer> mergeList) {
        this.mergeList = mergeList;
    }

    public void setAutoMerge(boolean autoMerge) {
        this.autoMerge = autoMerge;
    }

    public void setFilter(boolean isFilter) {
        this.isFilter = isFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportListExcel)) {
            return false;
        }
        ExportListExcel other = (ExportListExcel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRowCounts() != other.getRowCounts()) {
            return false;
        }
        if (this.isAutoMerge() != other.isAutoMerge()) {
            return false;
        }
        if (this.isFilter() != other.isFilter()) {
            return false;
        }
        HSSFWorkbook this$wb = this.getWb();
        HSSFWorkbook other$wb = other.getWb();
        if (this$wb == null ? other$wb != null : !this$wb.equals(other$wb)) {
            return false;
        }
        HSSFSheet this$sheet = this.getSheet();
        HSSFSheet other$sheet = other.getSheet();
        if (this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet)) {
            return false;
        }
        HSSFDataFormat this$format = this.getFormat();
        HSSFDataFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        HSSFRow this$hdRow = this.getHdRow();
        HSSFRow other$hdRow = other.getHdRow();
        if (this$hdRow == null ? other$hdRow != null : !this$hdRow.equals(other$hdRow)) {
            return false;
        }
        List<String> this$headers = this.getHeaders();
        List<String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<String> this$fieldNames = this.getFieldNames();
        List<String> other$fieldNames = other.getFieldNames();
        if (this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames)) {
            return false;
        }
        List<Integer> this$mergeList = this.getMergeList();
        List<Integer> other$mergeList = other.getMergeList();
        return !(this$mergeList == null ? other$mergeList != null : !((Object)this$mergeList).equals(other$mergeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportListExcel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowCounts();
        result = result * 59 + (this.isAutoMerge() ? 79 : 97);
        result = result * 59 + (this.isFilter() ? 79 : 97);
        HSSFWorkbook $wb = this.getWb();
        result = result * 59 + ($wb == null ? 43 : $wb.hashCode());
        HSSFSheet $sheet = this.getSheet();
        result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
        HSSFDataFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        HSSFRow $hdRow = this.getHdRow();
        result = result * 59 + ($hdRow == null ? 43 : $hdRow.hashCode());
        List<String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<String> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : ((Object)$fieldNames).hashCode());
        List<Integer> $mergeList = this.getMergeList();
        result = result * 59 + ($mergeList == null ? 43 : ((Object)$mergeList).hashCode());
        return result;
    }

    public String toString() {
        return "ExportListExcel(wb=" + this.getWb() + ", sheet=" + this.getSheet() + ", format=" + this.getFormat() + ", hdRow=" + this.getHdRow() + ", rowCounts=" + this.getRowCounts() + ", headers=" + this.getHeaders() + ", fieldNames=" + this.getFieldNames() + ", mergeList=" + this.getMergeList() + ", autoMerge=" + this.isAutoMerge() + ", isFilter=" + this.isFilter() + ")";
    }
}

