/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.excel;

import cn.smarthse.common.framework.enums.HtmlEntityEnum;
import cn.smarthse.common.util.date.DateUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcel<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String title, String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(15);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font2 = workbook.createFont();
        font2.setBold(true);
        style2.setFont(font2);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
        comment.setAuthor("admin");
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(style);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; i = (int)((short)(i + 1))) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(style2);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) {
                        textValue = "";
                    } else if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Boolean) {
                        boolean bValue = (Boolean)value;
                        textValue = "\u7537";
                        if (!bValue) {
                            textValue = "\u5973";
                        }
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture(anchor, workbook.addPicture(bsValue, 5));
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    HSSFFont font3 = workbook.createFont();
                    font3.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
                    richString.applyFont((Font)font3);
                    cell.setCellValue((RichTextString)richString);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport(String title, String[] headers, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            row.createCell((int)((short)i)).setCellValue(headers[i]);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                HSSFCell cell = row.createCell((int)((short)i));
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport5(HSSFWorkbook workbook, String title, String[] colums, List<T> dataset) {
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell((int)((short)i)).setCellValue((String)headers.get(i));
            row.getCell(i).setCellStyle(style);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("export_index".equals(fieldName)) {
                    cell.setCellValue((double)index);
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        Boolean flag;
                        textValue = value instanceof Boolean ? ((flag = (Boolean)value) != null && flag.booleanValue() ? "\u662f" : "\u5426") : StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport2(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell((int)((short)i)).setCellValue((String)headers.get(i));
            row.getCell(i).setCellStyle(style);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("export_index".equals(fieldName)) {
                    cell.setCellValue((double)index);
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        Boolean flag;
                        textValue = value instanceof Boolean ? ((flag = (Boolean)value) != null && flag.booleanValue() ? "\u662f" : "\u5426") : StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportWithDVConstraint(String title, String[] colums, Map<Integer, String[]> constraintMap, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.VIOLET.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        if (constraintMap != null) {
            for (Map.Entry<Integer, String[]> entry : constraintMap.entrySet()) {
                DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])entry.getValue());
                CellRangeAddressList regions = new CellRangeAddressList(1, Integer.MAX_VALUE, entry.getKey().intValue(), entry.getKey().intValue());
                HSSFDataValidation dataValidationList = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
                sheet.addValidationData((DataValidation)dataValidationList);
            }
        }
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell((int)((short)i)).setCellValue((String)headers.get(i));
            row.getCell(i).setCellStyle(style);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("export_index".equals(fieldName)) {
                    cell.setCellValue((double)index);
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        Boolean flag;
                        textValue = value instanceof Boolean ? ((flag = (Boolean)value) != null && flag.booleanValue() ? "\u662f" : "\u5426") : StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void simpleExport5(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(5120);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] stringArray = colum.split("\\|");
            if (stringArray.length != 3) continue;
            headers.add(stringArray[0]);
            fieldNames.add(stringArray[1] + "|" + stringArray[2]);
        }
        HSSFCellStyle style = workbook.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setWrapText(true);
        HashMap headerMerMap = new HashMap();
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
            if (headerMerMap.get(headers.get(i)) == null) {
                headerMerMap.put(headers.get(i), new ArrayList());
            }
            ((List)headerMerMap.get(headers.get(i))).add(i);
            sheet.autoSizeColumn(i);
            row.getCell(i).setCellStyle(style);
        }
        ArrayList headMerIndexList = new ArrayList();
        for (String string : headerMerMap.keySet()) {
            List list = (List)headerMerMap.get(string);
            if (list == null || list.size() <= 1) continue;
            Integer start = (Integer)list.get(0);
            Integer end = (Integer)list.get(list.size() - 1);
            ArrayList<Integer> realList = new ArrayList<Integer>();
            headMerIndexList.add(realList);
            for (int i = start.intValue(); i <= end; ++i) {
                if (!list.contains(i)) {
                    realList = new ArrayList();
                    headMerIndexList.add(realList);
                    continue;
                }
                realList.add(i);
            }
        }
        for (List list : headMerIndexList) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, ((Integer)list.get(0)).intValue(), ((Integer)list.get(list.size() - 1)).intValue()));
        }
        Iterator<T> it = dataset.iterator();
        boolean bl = false;
        HashMap contentMerMap = new HashMap();
        while (it.hasNext()) {
            void var14_22;
            row = sheet.createRow((int)(++var14_22));
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(style);
                sheet.autoSizeColumn(i);
                String[] fieldNameAndMerFlag = ((String)fieldNames.get(i)).split("\\|");
                String fieldName = fieldNameAndMerFlag[0];
                String merFlag = fieldNameAndMerFlag[1];
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if ("true".equals(merFlag)) {
                        if (contentMerMap.get(i + "\u2764" + (value == null ? "" : value.toString())) == null) {
                            contentMerMap.put(i + "\u2764" + (value == null ? "" : value.toString()), new ArrayList());
                        }
                        ((List)contentMerMap.get(i + "\u2764" + (value == null ? "" : value.toString()))).add((int)var14_22);
                    }
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        HashMap contentMerIndexMap = new HashMap();
        for (String content2 : contentMerMap.keySet()) {
            List list = (List)contentMerMap.get(content2);
            if (list == null || list.size() <= 1) continue;
            Integer start = (Integer)list.get(0);
            Integer end = (Integer)list.get(list.size() - 1);
            ArrayList realList = new ArrayList();
            contentMerIndexMap.put(content2, realList);
            for (int i = start.intValue(); i <= end; ++i) {
                if (!list.contains(i)) {
                    realList = new ArrayList();
                    contentMerIndexMap.put(content2, realList);
                    continue;
                }
                ((List)contentMerIndexMap.get(content2)).add(i);
            }
        }
        for (String colIndexKey : contentMerIndexMap.keySet()) {
            sheet.addMergedRegion(new CellRangeAddress(((Integer)((List)contentMerIndexMap.get(colIndexKey)).get(0)).intValue(), ((Integer)((List)contentMerIndexMap.get(colIndexKey)).get(((List)contentMerIndexMap.get(colIndexKey)).size() - 1)).intValue(), Integer.valueOf(colIndexKey.split("\u2764")[0]).intValue(), Integer.valueOf(colIndexKey.split("\u2764")[0]).intValue()));
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport3(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport6(String title, String[] colums, List<T> dataset, OutputStream out, String exportDate) {
        HSSFRow row;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(16);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        if (StringUtils.isNotBlank((CharSequence)exportDate)) {
            row = sheet.createRow(0);
            row.createCell(0).setCellValue(exportDate);
        }
        row = sheet.createRow(1);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 1;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportAutoSheet(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        int size = dataset.size();
        int pageSize = 50000;
        int sheetNum = (int)Math.ceil((double)size * 1.0 / (double)pageSize);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        int dataIndex = 0;
        for (int num = 0; num < sheetNum; ++num) {
            HSSFSheet sheet = workbook.createSheet(title + String.valueOf(num + 1));
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < headers.size(); ++i) {
                row.createCell(i).setCellValue((String)headers.get(i));
            }
            int index = 0;
            for (int j = dataIndex; j < dataset.size() && j < pageSize * (num + 1); ++j) {
                ++dataIndex;
                row = sheet.createRow(++index);
                T t = dataset.get(j);
                for (int i = 0; i < fieldNames.size(); ++i) {
                    HSSFCell cell = row.createCell(i);
                    String fieldName = (String)fieldNames.get(i);
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        Object value = getMethod.invoke(t, new Object[0]);
                        String textValue = null;
                        if (value == null) continue;
                        if (value instanceof Integer) {
                            int intValue = (Integer)value;
                            cell.setCellValue((double)intValue);
                        } else if (value instanceof Float) {
                            float fValue = ((Float)value).floatValue();
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Double) {
                            double dValue = (Double)value;
                            HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                            cell.setCellValue((RichTextString)richText);
                        } else if (value instanceof Long) {
                            long longValue = (Long)value;
                            cell.setCellValue((double)longValue);
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            textValue = sdf.format(date);
                        } else {
                            textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                        }
                        if (textValue == null) continue;
                        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                        Matcher matcher = p.matcher(textValue);
                        if (matcher.matches()) {
                            cell.setCellValue(Double.parseDouble(textValue));
                            continue;
                        }
                        cell.setCellValue(textValue);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport4(String title, String[] colums, List<Map<String, Object>> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<Map<String, Object>> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                try {
                    Object value = t.get(fieldName);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportAutoWidth(String title, String[] colums, List<T> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        HashMap<Integer, Integer> maxLen = new HashMap<Integer, Integer>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                    } else {
                        cell.setCellValue(textValue);
                    }
                    if (!maxLen.containsKey(i)) {
                        maxLen.put(i, textValue.length() * 500);
                        continue;
                    }
                    Integer max = (Integer)maxLen.get(i);
                    if (max >= textValue.length() * 500) continue;
                    maxLen.put(i, textValue.length() * 500);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        Set setLen = maxLen.keySet();
        for (Integer key : setLen) {
            sheet.setColumnWidth(key.intValue(), ((Integer)maxLen.get(key)).intValue());
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportAutoWidthAndHeight(String title, String[] colums, List<T> dataset, Integer width, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).getCellStyle().setWrapText(true);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        HashMap<Integer, Integer> maxLen = new HashMap<Integer, Integer>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                    } else {
                        cell.setCellValue(textValue);
                    }
                    if (!maxLen.containsKey(i)) {
                        maxLen.put(i, textValue.length() * 500);
                        continue;
                    }
                    Integer max = (Integer)maxLen.get(i);
                    if (max >= textValue.length() * 500) continue;
                    maxLen.put(i, textValue.length() * 500);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        Set setLen = maxLen.keySet();
        for (Integer key : setLen) {
            if ((Integer)maxLen.get(key) < 65280) {
                sheet.setColumnWidth(key.intValue(), ((Integer)maxLen.get(key)).intValue());
                continue;
            }
            sheet.setColumnWidth(key.intValue(), width.intValue());
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generaExcel(String title, String[] colums, List<T> dataset, Integer width, String targetFile) throws FileNotFoundException, UnsupportedEncodingException {
        File f = FileUtils.getFile((String[])new String[]{targetFile});
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).getCellStyle().setWrapText(true);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        HashMap<Integer, Integer> maxLen = new HashMap<Integer, Integer>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                    } else {
                        cell.setCellValue(textValue);
                    }
                    if (!maxLen.containsKey(i)) {
                        maxLen.put(i, textValue.length() * 500);
                        continue;
                    }
                    Integer max = (Integer)maxLen.get(i);
                    if (max >= textValue.length() * 500) continue;
                    maxLen.put(i, textValue.length() * 500);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        Set setLen = maxLen.keySet();
        for (Integer key : setLen) {
            if ((Integer)maxLen.get(key) < 65280) {
                sheet.setColumnWidth(key.intValue(), ((Integer)maxLen.get(key)).intValue());
                continue;
            }
            sheet.setColumnWidth(key.intValue(), width.intValue());
        }
        try {
            workbook.write(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleMapExport(String title, String[] colums, List<Map<String, Object>> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        HSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<Map<String, Object>> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                try {
                    Object value = null;
                    String textValue = null;
                    if (!t.containsKey(fieldName)) continue;
                    value = t.get(fieldName);
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(String fileName, String sheetName, String[] headers, List<T> datas, OutputStream out, int mergeIndex) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            ArrayList<String> titles = new ArrayList<String>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (String colum : headers) {
                String[] t = colum.split("\\|");
                if (t.length != 2) continue;
                titles.add(t[0]);
                fieldNames.add(t[1]);
            }
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < titles.size(); ++i) {
                row.createCell(i).setCellValue((String)titles.get(i));
            }
            String mergeValue = null;
            boolean mergeFlag = false;
            int mergeCount = 0;
            Iterator<T> it = datas.iterator();
            int index = 0;
            while (it.hasNext()) {
                row = sheet.createRow(++index);
                T t = it.next();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    String fieldName = (String)fieldNames.get(i);
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        Object value = getMethod.invoke(t, new Object[0]);
                        if (value == null) continue;
                        String textValue = value.toString();
                        HSSFCell cell = null;
                        if (mergeIndex != i) {
                            cell = row.createCell(i);
                            cell.setCellValue(textValue);
                            continue;
                        }
                        if (mergeValue == null || !textValue.equals(mergeValue)) {
                            mergeValue = textValue;
                            cell = row.createCell(i);
                            cell.setCellValue(textValue);
                            mergeFlag = mergeCount > 0;
                            continue;
                        }
                        ++mergeCount;
                        mergeFlag = false;
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (mergeCount <= 0 || !mergeFlag) continue;
                sheet.addMergedRegion(new CellRangeAddress(index - mergeCount, index, 0, 0));
                mergeCount = 0;
                mergeFlag = false;
            }
            try {
                wb.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportXlsx(String title, String[] colums, List<T> dataset, OutputStream out) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        XSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("\u5e8f\u53f7");
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("index");
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                XSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("index".equals(fieldName)) {
                    cell.setCellValue((double)index);
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCustomExportXlsx(String title, String[] colums, List<T> dataset, OutputStream out) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        XSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("\u5e8f\u53f7");
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("index");
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                XSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("index".equals(fieldName)) {
                    cell.setCellValue((double)index);
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Object value;
                    if (t instanceof Map) {
                        Map map = (Map)t;
                        value = map.get(fieldName);
                    } else {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        value = getMethod.invoke(t, new Object[0]);
                    }
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExportXlsx(String title, Integer rowNum, String[] colums, List<T> dataset, OutputStream out, Boolean forge) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        if (forge.booleanValue()) {
            XSSFRow row2 = sheet.createRow(0);
            ArrayList<String> headers2 = new ArrayList<String>(1);
            headers2.add(DateUtil.format(new Date(), "yyyy-MM-dd"));
            for (int i = 0; i < headers2.size(); ++i) {
                row2.createCell(i).setCellValue((String)headers2.get(i));
            }
        }
        XSSFRow row = sheet.createRow(rowNum.intValue());
        ArrayList<String> headers = new ArrayList<String>(colums.length);
        headers.add("\u5e8f\u53f7");
        ArrayList<String> fieldNames = new ArrayList<String>(colums.length);
        fieldNames.add("index");
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = rowNum;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                XSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                if ("index".equals(fieldName)) {
                    cell.setCellValue((double)(index - rowNum));
                    continue;
                }
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        textValue = sdf.format(date);
                    } else {
                        textValue = StringEscapeUtils.unescapeHtml((String)HtmlEntityEnum.replaceAllCode(value.toString()));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

