/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.enums;

import cn.smarthse.common.framework.enums.HtmlEntityEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum SquareCharEnum {
    zero("0", "\u00ba"),
    one("1", "\u00b9"),
    two("2", "\u00b2"),
    three("3", "\u00b3"),
    four("4", "\u2074"),
    five("5", "\u2075"),
    six("6", "\u2076"),
    seven("7", "\u2077"),
    eight("8", "\u2078"),
    nine("9", "\u2079");

    private String character;
    private String code;

    private SquareCharEnum(String character, String code) {
        this.character = character;
        this.code = code;
    }

    public static String getCharacterByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (HtmlEntityEnum html : HtmlEntityEnum.values()) {
            if (!html.getCode().equals(code)) continue;
            return html.getCharacter();
        }
        return null;
    }

    public static String replaceAllCode(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (str.indexOf("&") == -1) {
            return str;
        }
        for (HtmlEntityEnum html : HtmlEntityEnum.values()) {
            str = str.replace(html.getCode(), html.getCharacter());
        }
        return str;
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

