/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum HtmlEntityEnum {
    times("\u00d7", "&times;"),
    Alpha("\u0391", "&Alpha;"),
    Delta("\u0394", "&Delta;"),
    Eta("\u0397", "&Eta;"),
    Kappa("\u039a", "&Kappa;"),
    Nu("\u039d", "&Nu;"),
    Pi("\u03a0", "&Pi;"),
    Tau("\u03a4", "&Tau;"),
    Chi("\u03a7", "&Chi;"),
    alpha("\u03b1", "&alpha;"),
    delta("\u03b4", "&delta;"),
    eta("\u03b7", "&eta;"),
    kappa("\u03ba", "&kappa;"),
    nu("\u03bd", "&nu;"),
    pi("\u03c0", "&pi;"),
    sigma("\u03c3", "&sigma;"),
    phi("\u03c6", "&phi;"),
    omega("\u03c9", "&omega;"),
    piv("\u03d6", "&piv;"),
    prime("\u2032", "&prime;"),
    frasl("\u2044", "&frasl;"),
    real("\u211c", "&real;"),
    larr("\u2190", "&larr;"),
    darr("\u2193", "&darr;"),
    lArr("\u21d0", "&lArr;"),
    dArr("\u21d3", "&dArr;"),
    part("\u2202", "&part;"),
    nabla("\u2207", "&nabla;"),
    ni("\u220b", "&ni;"),
    minus("\u2212", "&minus;"),
    prop("\u221d", "&prop;"),
    and("\u2227", "&and;"),
    cup("\u222a", "&cup;"),
    sim("\u223c", "&sim;"),
    ne("\u2260", "&ne;"),
    ge("\u2265", "&ge;"),
    nsub("\u2284", "&nsub;"),
    oplus("\u2295", "&oplus;"),
    sdot("\u22c5", "&sdot;"),
    lfloor("\u230a", "&lfloor;"),
    spades("\u2660", "&spades;"),
    diams("\u2666", "&diams;"),
    cent("\u00a2", "&cent;"),
    yen("\u00a5", "&yen;"),
    uml("\u00a8", "&uml;"),
    laquo("\u00ab", "&laquo;"),
    reg("\u00ae", "&reg;"),
    plusmn("\u00b1", "&plusmn;"),
    acute("\u00b4", "&acute;"),
    lt("<", "&lt;"),
    Beta("\u0392", "&Beta;"),
    Epsilon("\u0395", "&Epsilon;"),
    Theta("\u0398", "&Theta;"),
    Lambda("\u039b", "&Lambda;"),
    Xi("\u039e", "&Xi;"),
    Rho("\u03a1", "&Rho;"),
    Upsilon("\u03a5", "&Upsilon;"),
    Psi("\u03a8", "&Psi;"),
    beta("\u03b2", "&beta;"),
    epsilon("\u03b5", "&epsilon;"),
    theta("\u03b8", "&theta;"),
    lambda("\u03bb", "&lambda;"),
    xi("\u03be", "&xi;"),
    rho("\u03c1", "&rho;"),
    tau("\u03c4", "&tau;"),
    chi("\u03c7", "&chi;"),
    thetasym("\u03d1", "&thetasym;"),
    bull("\u2022", "&bull;"),
    Prime("\u2033", "&Prime;"),
    weierp("\u2118", "&weierp;"),
    trade("\u2122", "&trade;"),
    uarr("\u2191", "&uarr;"),
    harr("\u2194", "&harr;"),
    uArr("\u21d1", "&uArr;"),
    hArr("\u21d4", "&hArr;"),
    exist("\u2203", "&exist;"),
    isin("\u2208", "&isin;"),
    prod("\u220f", "&prod;"),
    lowast("\u2217", "&lowast;"),
    infin("\u221e", "&infin;"),
    or("\u2228", "&or;"),
    _int("\u222b", "&int;"),
    cong("\u2245", "&cong;"),
    equiv("\u2261", "&equiv;"),
    sub("\u2282", "&sub;"),
    sube("\u2286", "&sube;"),
    otimes("\u2297", "&otimes;"),
    lceil("\u2308", "&lceil;"),
    rfloor("\u230b", "&rfloor;"),
    clubs("\u2663", "&clubs;"),
    nbsp(" ", "&nbsp;"),
    pound("\u00a3", "&pound;"),
    brvbar("\u00a6", "&brvbar;"),
    copy("\u00a9", "&copy;"),
    not("\u00ac", "&not;"),
    macr("\u00af", "&macr;"),
    sup2("\u00b2", "&sup2;"),
    micro("\u00b5", "&micro;"),
    gt(">", "&gt;"),
    Gamma("\u0393", "&Gamma;"),
    Zeta("\u0396", "&Zeta;"),
    Iota("\u0399", "&Iota;"),
    Mu("\u039c", "&Mu;"),
    Omicron("\u039f", "&Omicron;"),
    Sigma("\u03a3", "&Sigma;"),
    Phi("\u03a6", "&Phi;"),
    Omega("\u03a9", "&Omega;"),
    gamma("\u03b3", "&gamma;"),
    zeta("\u03b6", "&zeta;"),
    iota("\u03b9", "&iota;"),
    mu("\u03bc", "&mu;"),
    omicron("\u03bf", "&omicron;"),
    sigmaf("\u03c2", "&sigmaf;"),
    upsilon("\u03c5", "&upsilon;"),
    psi("\u03c8", "&psi;"),
    upsih("\u03d2", "&upsih;"),
    hellip("\u2026", "&hellip;"),
    oline("\u203e", "&oline;"),
    image("\u2111", "&image;"),
    alefsym("\u2135", "&alefsym;"),
    rarr("\u2192", "&rarr;"),
    crarr("\u21b5", "&crarr;"),
    rArr("\u21d2", "&rArr;"),
    forall("\u2200", "&forall;"),
    empty("\u2205", "&empty;"),
    notin("\u2209", "&notin;"),
    sum("\u2211", "&sum;"),
    radic("\u221a", "&radic;"),
    ang("\u2220", "&ang;"),
    cap("\u2229", "&cap;"),
    there4("\u2234", "&there4;"),
    asymp("\u2248", "&asymp;"),
    le("\u2264", "&le;"),
    sup("\u2283", "&sup;"),
    supe("\u2287", "&supe;"),
    perp("\u22a5", "&perp;"),
    rceil("\u2309", "&rceil;"),
    loz("\u25ca", "&loz;"),
    hearts("\u2665", "&hearts;"),
    iexcl("\u00a1", "&iexcl;"),
    curren("\u00a4", "&curren;"),
    sect("\u00a7", "&sect;"),
    ordf("\u00aa", "&ordf;"),
    shy("", "&shy;"),
    deg("\u00b0", "&deg;"),
    sup3("\u00b3", "&sup3;"),
    quot("\"", "&quot;"),
    _and("&", "&amp;");

    private String character;
    private String code;

    private HtmlEntityEnum(String character, String code) {
        this.character = character;
        this.code = code;
    }

    public static String getCharacterByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (HtmlEntityEnum html : HtmlEntityEnum.values()) {
            if (!html.getCode().equals(code)) continue;
            return html.getCharacter();
        }
        return null;
    }

    public static String replaceAllCode(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (str.indexOf("&") == -1) {
            return str;
        }
        for (HtmlEntityEnum html : HtmlEntityEnum.values()) {
            str = str.replace(html.getCode(), html.getCharacter());
        }
        return str;
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

