/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.easyExcel;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.context.SheetWriteHandlerContext;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class EasyExcelDropDownBox
implements SheetWriteHandler {
    private int firstRow;
    private Map<Integer, String[]> dropDownBoxData;

    public void afterSheetCreate(SheetWriteHandlerContext context) {
        Sheet sheet = context.getWriteSheetHolder().getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        for (Map.Entry<Integer, String[]> integerEntry : this.dropDownBoxData.entrySet()) {
            CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(this.firstRow, 65535, integerEntry.getKey().intValue(), integerEntry.getKey().intValue());
            DataValidationConstraint constraint = helper.createExplicitListConstraint(integerEntry.getValue());
            DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
            if (dataValidation instanceof XSSFDataValidation) {
                dataValidation.setSuppressDropDownArrow(true);
                dataValidation.setShowErrorBox(true);
            } else {
                dataValidation.setSuppressDropDownArrow(false);
            }
            sheet.addValidationData(dataValidation);
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void setDropDownBoxData(Map<Integer, String[]> dropDownBoxData) {
        this.dropDownBoxData = dropDownBoxData;
    }

    public EasyExcelDropDownBox() {
    }

    public EasyExcelDropDownBox(int firstRow, Map<Integer, String[]> dropDownBoxData) {
        this.firstRow = firstRow;
        this.dropDownBoxData = dropDownBoxData;
    }
}

