/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.database.persistence;

import cn.smarthse.common.framework.enums.ResponseStateEnum;
import java.io.Serializable;

public class ResponseData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ResponseStateEnum state = ResponseStateEnum.success;
    private String content = ResponseStateEnum.success.getName();
    private T result;

    public ResponseData(ResponseStateEnum state, String content2, T result) {
        this.state = state;
        this.content = content2;
        this.result = result;
    }

    public ResponseData(ResponseStateEnum state, String content2) {
        this.state = state;
        this.content = content2;
    }

    public ResponseData(ResponseStateEnum state, T result) {
        this.state = state;
        this.content = state.getName();
        this.result = result;
    }

    public ResponseData(String content2, T result) {
        this.content = content2;
        this.result = result;
    }

    public ResponseData(T result) {
        this.content = ResponseStateEnum.success.getName();
        this.result = result;
    }

    public ResponseData(String content2) {
        this.content = content2;
    }

    public ResponseData(ResponseStateEnum state) {
        this(state, state.getName());
    }

    public static <T> ResponseData<T> success() {
        return new ResponseData<T>();
    }

    public static <T> ResponseData<T> success(T result) {
        return new ResponseData<T>(ResponseStateEnum.success, result);
    }

    public static <T> ResponseData<T> success(String content2) {
        return new ResponseData<Object>(ResponseStateEnum.success, content2, null);
    }

    public static <T> ResponseData<T> success(String content2, T result) {
        return new ResponseData<T>(ResponseStateEnum.success, content2, result);
    }

    public static <T> ResponseData<T> fail() {
        return new ResponseData<T>(ResponseStateEnum.fail);
    }

    public static <T> ResponseData<T> fail(T result) {
        return new ResponseData<T>(ResponseStateEnum.fail, result);
    }

    public static <T> ResponseData<T> fail(String content2) {
        return new ResponseData<Object>(ResponseStateEnum.fail, content2, null);
    }

    public static <T> ResponseData<T> fail(String content2, T result) {
        return new ResponseData<T>(ResponseStateEnum.fail, content2, result);
    }

    public ResponseData() {
    }

    public ResponseStateEnum getState() {
        return this.state;
    }

    public String getContent() {
        return this.content;
    }

    public T getResult() {
        return this.result;
    }

    public void setState(ResponseStateEnum state) {
        this.state = state;
    }

    public void setContent(String content2) {
        this.content = content2;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseStateEnum this$state = this.getState();
        ResponseStateEnum other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseStateEnum $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(state=" + (Object)((Object)this.getState()) + ", content=" + this.getContent() + ", result=" + this.getResult() + ")";
    }
}

