/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.config;

import cn.smarthse.common.util.PropertiesLoader;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Global {
    public static final Byte ACTIVE_YES = 1;
    public static final Byte ACTIVE_NO = 0;
    public static final String SHOW = "1";
    public static final String HIDE = "0";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final Boolean TRUE = true;
    public static final Boolean FALSE = false;
    public static final String USER_MULTI_ACCOUNT_LOGIN = "user.multiAccountLogin";
    public static final String multiAccountLoginAccount = "user.multiAccountLoginAccount";
    public static final String staticFiles = ".css,.js,.png,.jpg,.gif,.jpeg,.bmp,.ico,.swf,.psd,.htc,.htm,.html,.crx,.xpi,.exe,.ipa,.apk";
    public static final String web_view_prefix = "/WEB-INF/views/";
    public static final String web_view_suffix = ".jsp";
    private static Global global = new Global();
    private static Map<String, String> map = Maps.newHashMap();
    private static PropertiesLoader loader = new PropertiesLoader("smarthsetech.properties");

    public static Global getInstance() {
        return global;
    }

    public static Object getConst(String field) {
        try {
            return Global.class.getField(field).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getConfig(String key) {
        String value = map.get(key);
        if (value == null) {
            value = loader.getProperty(key);
            map.put(key, value != null ? value : "");
        }
        return value;
    }

    public static boolean enableMultiAccountLogin() {
        return Global.getConfig(USER_MULTI_ACCOUNT_LOGIN).equalsIgnoreCase("true") || Global.getConfig(USER_MULTI_ACCOUNT_LOGIN).equalsIgnoreCase("on");
    }

    public static List<String> getMultiAccountLoginAccount() {
        String str = Global.getConfig(multiAccountLoginAccount);
        return str != null ? Arrays.stream(str.toLowerCase().split(",")).collect(Collectors.toList()) : null;
    }
}

