/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.cache.memcached;

import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class MemcachedCache
implements Cache {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int CACHE_EXP_DAY = 86400;
    public static final int CACHE_EXP_WEEK = 604800;
    public static final int CACHE_EXP_MONTH = 18144000;
    public static final int CACHE_EXP_HOUR = 7200;
    public static final int CACHE_EXP_FOREVER = 0;
    private com.google.code.ssm.Cache cache;
    private int expiretime = 7200;

    public com.google.code.ssm.Cache getCache() {
        return this.cache;
    }

    public void setCache(com.google.code.ssm.Cache cache) {
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public int getExpiretime() {
        return this.expiretime;
    }

    public void setExpiretime(int expiretime) {
        this.expiretime = expiretime;
    }

    public Cache.ValueWrapper get(Object key) {
        Object object = null;
        try {
            this.logger.info("\u8bfb\u53d6\u7f13\u5b58:" + key);
            object = this.cache.get((String)key, SerializationType.JAVA);
        }
        catch (TimeoutException e) {
            this.logger.warn("\u83b7\u53d6 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
        }
        catch (CacheException e) {
            this.logger.warn("\u83b7\u53d6 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", (Throwable)e);
        }
        return object != null ? new SimpleValueWrapper(object) : null;
    }

    public void put(Object key, Object value) {
        if (value == null) {
            return;
        }
        try {
            this.logger.info("\u4fdd\u5b58\u7f13\u5b58:" + key);
            this.cache.set((String)key, this.expiretime, value, SerializationType.JAVA);
        }
        catch (TimeoutException e) {
            this.logger.warn("\u66f4\u65b0 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
        }
        catch (CacheException e) {
            this.logger.warn("\u66f4\u65b0 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", (Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            this.logger.info("\u5220\u9664\u7f13\u5b58:" + key);
            this.cache.delete((String)key);
        }
        catch (TimeoutException e) {
            this.logger.warn("\u5220\u9664 Memcached \u7f13\u5b58\u8d85\u65f6", (Throwable)e);
        }
        catch (CacheException e) {
            this.logger.warn("\u5220\u9664 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", (Throwable)e);
        }
    }

    public void clear() {
        try {
            this.logger.info("\u6e05\u7a7a\u7f13\u5b58");
            this.cache.flush();
        }
        catch (TimeoutException e) {
            this.logger.warn("\u6e05\u9664 Memcached \u7f13\u5b58\u88ab\u4e2d\u65ad", (Throwable)e);
        }
        catch (CacheException e) {
            this.logger.warn("\u6e05\u9664 Memcached \u7f13\u5b58\u9519\u8bef", (Throwable)e);
        }
    }

    @Deprecated
    public <T> T get(Object arg0, Class<T> arg1) {
        return null;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        return null;
    }

    @Deprecated
    public Cache.ValueWrapper putIfAbsent(Object arg0, Object arg1) {
        return null;
    }
}

