/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.cache.ehcache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    public static int MAXELEMENTSINMEMORY = 50000;
    public static boolean OVERFLOWTODISK = true;
    public static boolean ETERNAL = false;
    public static int TIMETOIDLESECONDS = 600;
    public static int TIMETOlIVESECONDS = 86400;
    public static boolean DISKPERSISTENT = false;
    public static String MEMORYSTOREEVICTIONPOLICY = "LFU";
    private static CacheManager cacheManager = null;
    private static Cache cache = null;

    public static CacheManager initCacheManager() {
        try {
            if (cacheManager == null) {
                cacheManager = CacheManager.getInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cacheManager;
    }

    public static Cache initCache(String cacheName) {
        CacheUtils.checkCacheManager();
        if (null == cacheManager.getCache(cacheName)) {
            cacheManager.addCache(cacheName);
        }
        cache = cacheManager.getCache(cacheName);
        return cache;
    }

    public static void put(Object key, Object value) {
        CacheUtils.checkCache();
        Element oldElement = cache.get(key);
        if (value instanceof Map && oldElement != null && oldElement.getValue() != null) {
            Map oldMap = (Map)((Object)oldElement.getValue());
            Map newMap = (Map)value;
            oldMap.putAll(newMap);
            Element newElement = new Element(key, (Object)oldMap);
            cache.put(newElement);
        } else {
            Element newElement = new Element(key, value);
            cache.put(newElement);
        }
    }

    public static void put(String cacheName, String key, Object value) {
        Cache myCache = CacheUtils.getCache(cacheName);
        Element oldElement = myCache.get((Serializable)((Object)key));
        if (value instanceof Map && oldElement != null && oldElement.getValue() != null) {
            Map oldMap = (Map)((Object)oldElement.getValue());
            Map newMap = (Map)value;
            oldMap.putAll(newMap);
            Element newElement = new Element((Object)key, (Object)oldMap);
            myCache.put(newElement);
        } else {
            Element newElement = new Element((Object)key, value);
            myCache.put(newElement);
        }
    }

    public static void add(Object key, Object value) {
        CacheUtils.checkCache();
        Element oldElement = cache.get(key);
        if (oldElement instanceof Map && value instanceof Map) {
            Map oldMap = (Map)oldElement;
            Map newMap = (Map)value;
            oldMap.putAll(newMap);
            Element newElement = new Element(key, (Object)oldMap);
            cache.put(newElement);
        } else {
            Element newElement = new Element(key, value);
            cache.put(newElement);
        }
    }

    public static Object get(Object key) {
        CacheUtils.checkCache();
        Element element = cache.get(key);
        if (null == element) {
            return null;
        }
        return element.getObjectValue();
    }

    public static Object getObjectBeginWith(String key) {
        CacheUtils.checkCache();
        Element element = cache.get((Serializable)((Object)key));
        if (null == element) {
            return null;
        }
        Attribute name = cache.getSearchAttribute("name");
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        query.addCriteria(name.ilike(key + "?"));
        Results results = query.execute();
        List resultList = results.all();
        for (Result result : resultList) {
            if (results.hasKeys()) {
                System.out.println(result.getKey());
            }
            if (!results.hasValues()) continue;
        }
        return element.getObjectValue();
    }

    public static Cache initCache(String cacheName, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) throws Exception {
        try {
            Cache myCache = CacheUtils.getCache(cacheName);
            if (myCache != null) {
                CacheConfiguration config = myCache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                config.setOverflowToDisk(overflowToDisk);
                config.setEternal(eternal);
                config.setTimeToIdleSeconds(timeToIdleSeconds);
            } else {
                myCache = CacheUtils.initCache(cacheName, timeToLiveSeconds);
            }
            return myCache;
        }
        catch (Exception e) {
            throw new Exception("init cache " + cacheName + " failed!!!");
        }
    }

    public static Cache initCache(String cacheName, long timeToLiveSeconds) throws Exception {
        return CacheUtils.initCache(cacheName, MAXELEMENTSINMEMORY, OVERFLOWTODISK, ETERNAL, timeToLiveSeconds, TIMETOIDLESECONDS);
    }

    public static boolean modifyCache(String cacheName, long timeToLiveSeconds, int maxElementsInMemory) throws Exception {
        try {
            if (StringUtils.isNotBlank((String)cacheName) && timeToLiveSeconds != 0L && maxElementsInMemory != 0) {
                Cache myCache = CacheUtils.getCache(cacheName);
                CacheConfiguration config = myCache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new Exception("modify cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value) throws Exception {
        try {
            Cache myCache = CacheUtils.getCache(cacheName);
            myCache.put(new Element((Object)key, value));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value, Integer timeToLiveSeconds) throws Exception {
        try {
            Cache myCache = CacheUtils.getCache(cacheName);
            myCache.put(new Element((Object)key, value, Boolean.valueOf(ETERNAL), Integer.valueOf(TIMETOIDLESECONDS), timeToLiveSeconds));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static Object getValue(String key) throws Exception {
        try {
            return cache.get((Serializable)((Object)key)).getObjectValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValue(String cacheName, String key) {
        if (logger.isInfoEnabled()) {
            logger.info("{}\u83b7\u53d6\u7f13\u5b58:{}", (Object)cacheName, (Object)key);
        }
        return CacheUtils.getCache(cacheName).get((Serializable)((Object)key)).getObjectValue();
    }

    public static boolean removeEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheUtils.initCacheManager();
            myManager.removeCache(cacheName);
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeAllEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheUtils.initCacheManager();
            myManager.removalAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeElment(String cacheName, String key) {
        try {
            Cache myCache = CacheUtils.getCache(cacheName);
            myCache.remove((Serializable)((Object)key));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean removeAllElment(String cacheName, String key) throws Exception {
        try {
            Cache myCache = CacheUtils.getCache(cacheName);
            myCache.removeAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static void shutdown() {
        cacheManager.shutdown();
    }

    public static void removeCache(String cacheName) {
        CacheUtils.checkCacheManager();
        Cache myCache = CacheUtils.getCache(cacheName);
        if (null != myCache) {
            cacheManager.removeCache(cacheName);
        }
    }

    public static void remove(String key) {
        CacheUtils.checkCache();
        cache.remove((Serializable)((Object)key));
    }

    public static void removeAllCache() {
        CacheUtils.checkCacheManager();
        cacheManager.removalAll();
    }

    public static void removeAllKey() {
        CacheUtils.checkCache();
        cache.removeAll();
    }

    public static String[] getAllCaches() {
        CacheUtils.checkCacheManager();
        return cacheManager.getCacheNames();
    }

    private static Cache getCache(String cacheName) {
        CacheUtils.initCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cache = CacheUtils.initCache(cacheName);
        }
        return cache;
    }

    public static List getKeys() {
        CacheUtils.checkCache();
        return cache.getKeys();
    }

    private static void checkCacheManager() {
        if (null == cacheManager) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316CacheManager\u503c\uff1aEHCacheUtil.initCacheManager");
        }
    }

    private static void checkCache() {
        if (null == cache) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316Cache\u503c\uff1aEHCacheUtil.initCache(\u53c2\u6570)");
        }
    }

    static {
        CacheUtils.initCacheManager();
        CacheUtils.initCache("cache");
    }
}

