/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MethodCacheInterceptor
implements MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MethodCacheInterceptor.class);
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void afterPropertiesSet() throws Exception {
        log.info(this.cache + " A cache is required. Use setCache(Cache) to provide one.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String targetName = invocation.getThis().getClass().getName();
        String methodName = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        String cacheKey = this.getCacheKey(targetName, methodName, arguments);
        Element element = null;
        MethodCacheInterceptor methodCacheInterceptor = this;
        synchronized (methodCacheInterceptor) {
            element = this.cache.get((Serializable)((Object)cacheKey));
            if (element == null) {
                log.info(cacheKey + "\u52a0\u5165\u5230\u7f13\u5b58\uff1a " + this.cache.getName());
                Object result = invocation.proceed();
                element = new Element((Serializable)((Object)cacheKey), (Serializable)result);
                this.cache.put(element);
            } else {
                log.info(cacheKey + "\u4f7f\u7528\u7f13\u5b58\uff1a " + this.cache.getName());
            }
        }
        return element.getValue();
    }

    private String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetName).append(".").append(methodName);
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".").append(arguments[i]);
            }
        }
        return sb.toString();
    }
}

