/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.web.handler;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.core.domain.ResponseData;
import cn.smarthse.common.core.domain.ResponseStateEnum;
import cn.smarthse.common.core.exception.ServiceException;
import cn.smarthse.common.core.utils.ServletUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

@ControllerAdvice
public class SmarthseExceptionHandler
extends SimpleMappingExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(SmarthseExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseData<Object> dealException(Exception ex) {
        ResponseData r = new ResponseData();
        if (ex instanceof ConstraintViolationException) {
            Set message = ((ConstraintViolationException)ex).getConstraintViolations();
            HashMap map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(ResponseStateEnum.BAD_REQUEST.getName());
            r.setResult(map);
        } else if (ex instanceof MethodArgumentNotValidException) {
            List allErrors = ((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(ResponseStateEnum.BAD_REQUEST.getName());
            r.setResult(map);
        } else if (ex instanceof ServiceException) {
            r.setResult(((ServiceException)ex).getResult());
            r.setState(((ServiceException)ex).getCode());
            r.setMessage(ex.getMessage());
        } else if (ex instanceof HealthException) {
            ErrorEnum errorEnum = ((HealthException)ex).getError();
            if (Objects.isNull(errorEnum)) {
                r.setState(ResponseStateEnum.fail.getValue());
                r.setMessage(ex.getMessage());
            } else {
                Integer code = errorEnum.getCode();
                r.setState(code == 0 ? ResponseStateEnum.fail.getValue() : code);
                r.setMessage(ex.getMessage());
            }
        } else if (ex instanceof RpcException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("RPC\u670d\u52a1\u9519\u8bef\uff01");
        } else if (ex instanceof HttpMessageNotReadableException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("\u53c2\u6570\u6709\u8bef\uff01");
        } else if (ex instanceof MaxUploadSizeExceededException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("\u6587\u4ef6\u592a\u5927\uff01");
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage(ex.getMessage());
        } else {
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage(StrUtil.isNotBlank((CharSequence)ex.getMessage()) ? ex.getMessage() : ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        }
        HttpServletRequest request = ServletUtils.getRequest();
        log.error("uri:{}-param:{}-\u7edf\u4e00\u6355\u83b7\u5f02\u5e38=>:", new Object[]{request != null ? request.getRequestURI() : "", ServletUtils.getParamMap((ServletRequest)request), ex});
        return r;
    }
}

