/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.web.filter;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.common.core.utils.StringUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            return null;
        }
        return HtmlUtil.cleanHtmlTag((String)value).trim();
    }

    public Map<String, String[]> getParameterMap() {
        Map valueMap = super.getParameterMap();
        if (MapUtil.isEmpty((Map)valueMap)) {
            return valueMap;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(valueMap.size());
        map.putAll(valueMap);
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values == null) continue;
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = HtmlUtil.cleanHtmlTag((String)values[i]).trim();
            }
            map.put((String)entry.getKey(), escapseValues);
        }
        return map;
    }

    public String[] getParameterValues(String name) {
        Object[] values = super.getParameterValues(name);
        if (ArrayUtil.isEmpty((Object[])values)) {
            return values;
        }
        int length = values.length;
        String[] escapseValues = new String[length];
        for (int i = 0; i < length; ++i) {
            escapseValues[i] = HtmlUtil.cleanHtmlTag((String)values[i]).trim();
        }
        return escapseValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.isJsonRequest()) {
            return super.getInputStream();
        }
        String json = StrUtil.str((byte[])IoUtil.readBytes((InputStream)super.getInputStream(), (boolean)false), (Charset)StandardCharsets.UTF_8);
        if (StringUtils.isEmpty((String)json)) {
            return super.getInputStream();
        }
        json = HtmlUtil.cleanHtmlTag((String)json).trim();
        final byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream bis = IoUtil.toStream((byte[])jsonBytes);
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public int available() throws IOException {
                return jsonBytes.length;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bis.read();
            }
        };
    }

    public boolean isJsonRequest() {
        String header = super.getHeader("Content-Type");
        return StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)"application/json");
    }
}

