/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.web.config;

import cn.smarthse.common.core.utils.SpringUtils;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.util.HttpString;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.concurrent.Executor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@AutoConfiguration
public class UndertowConfig
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    public void customize(UndertowServletWebServerFactory factory) {
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(true, 1024));
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo);
            if (SpringUtils.isVirtual()) {
                VirtualThreadTaskExecutor executor = new VirtualThreadTaskExecutor("undertow-");
                deploymentInfo.setExecutor((Executor)executor);
                deploymentInfo.setAsyncExecutor((Executor)executor);
            }
            deploymentInfo.addInitialHandlerChainWrapper(handler -> {
                HttpString[] disallowedHttpMethods = new HttpString[]{HttpString.tryFromString((String)"CONNECT"), HttpString.tryFromString((String)"TRACE"), HttpString.tryFromString((String)"TRACK")};
                return new DisallowedMethodsHandler(handler, disallowedHttpMethods);
            });
        }});
    }
}

