/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.web.config;

import cn.smarthse.common.web.config.properties.XssProperties;
import cn.smarthse.common.web.filter.RepeatableFilter;
import cn.smarthse.common.web.filter.XssFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={XssProperties.class})
public class FilterConfig {
    private static final Logger log = LoggerFactory.getLogger(FilterConfig.class);

    @Bean
    @ConditionalOnProperty(value={"xss.enabled"}, havingValue="true")
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        log.info("\u521d\u59cb\u5316 XssFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("xssFilter");
        registration.setOrder(-2147483647);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RepeatableFilter> someFilterRegistration() {
        log.info("\u521d\u59cb\u5316 RepeatableFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RepeatableFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("repeatableFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }
}

