/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.common.model;

import cn.smarthse.web.common.enums.StatusCodeEnum;
import lombok.Generated;

public class ResponseData<T> {
    private Integer code;
    private String msg;
    private T data;

    public ResponseData() {
    }

    private ResponseData(StatusCodeEnum codeEnum, T data) {
        this.code = codeEnum.getCode();
        this.msg = codeEnum.getMsg();
        this.data = data;
    }

    private ResponseData(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <W> ResponseData<W> success(W data) {
        return new ResponseData<W>(StatusCodeEnum.SUCCESS, data);
    }

    public static <T> ResponseData<T> fail(String msg) {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), msg, null);
    }

    public static <T> ResponseData<T> fail(String msg, T data) {
        return new ResponseData<T>(StatusCodeEnum.FAIL.getCode(), msg, data);
    }

    public static <T> ResponseData<T> error(String msg) {
        return new ResponseData<Object>(StatusCodeEnum.ERROR.getCode(), msg, null);
    }

    public static ResponseData<Object> requestError() {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR, null);
    }

    public static <T> ResponseData<T> requestError(String msg) {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR.getCode(), msg, null);
    }

    public static ResponseData<Object> forbiddenError() {
        return new ResponseData<Object>(StatusCodeEnum.FORBIDDEN_ERROR, null);
    }

    public static ResponseData<Object> forceOffline() {
        return new ResponseData<Object>(StatusCodeEnum.FORCE_OFFLINE, null);
    }

    public static ResponseData<Object> invalidSession() {
        return new ResponseData<Object>(StatusCodeEnum.INVALID_SESSION, null);
    }

    public static ResponseData<Object> loginFail() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u767b\u5f55\u5931\u8d25\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801", null);
    }

    public static ResponseData<Object> verCodeError() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u5931\u6548", null);
    }

    public static ResponseData<Object> noLogin() {
        return new ResponseData<Object>(StatusCodeEnum.NO_LOGIN, null);
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public void setCode(Integer code) {
        this.code = code;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + String.valueOf(this.getData()) + ")";
    }
}

