/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.common.filter;

import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.web.common.model.ResponseData;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import lombok.Generated;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class KickoutSessionFilter
extends AccessControlFilter {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Boolean kickoutAfter = false;
    private String CACHE_PREFIX = "KICKOUT-PREFIX";
    private String kickoutUrl;
    private SessionManager sessionManager;
    private Cache<String, Deque<Serializable>> cache;
    List<String> multiAccountLoginAccountList;

    protected boolean isAccessAllowed(ServletRequest servletRequest, ServletResponse servletResponse, Object o) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        String loginName = subject.getPrincipal().toString().toLowerCase();
        if (this.multiAccountLoginAccountList != null && this.multiAccountLoginAccountList.contains(loginName)) {
            return true;
        }
        if (!subject.isAuthenticated()) {
            return true;
        }
        try {
            Session session = subject.getSession();
            Serializable sessionId = session.getId();
            ArrayDeque<Serializable> deque = (ArrayDeque<Serializable>)this.cache.get((Object)loginName);
            if (deque == null) {
                deque = new ArrayDeque<Serializable>();
            }
            if (!deque.contains(sessionId) && session.getAttribute((Object)"kickout") == null) {
                deque.push(sessionId);
                this.cache.put((Object)loginName, deque);
            }
            while (deque.size() > 1) {
                Serializable kickoutSessionId = this.kickoutAfter != false ? (Serializable)deque.removeFirst() : (Serializable)deque.removeLast();
                this.cache.put((Object)loginName, deque);
                try {
                    Session kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                    if (null == kickoutSession) continue;
                    kickoutSession.setAttribute((Object)"kickout", (Object)true);
                }
                catch (Exception exception) {}
            }
            if (session.getAttribute((Object)"kickout") != null && ((Boolean)session.getAttribute((Object)"kickout")).booleanValue()) {
                subject.logout();
                this.saveRequest(request);
                return this.isAjaxResponse(request, response);
            }
            return true;
        }
        catch (Exception e) {
            return this.isAjaxResponse(request, response);
        }
    }

    private boolean isAjaxResponse(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (ServletUtils.isAjaxRequest((HttpServletRequest)req)) {
            ResponseData data = ResponseData.fail("\u60a8\u5df2\u5728\u522b\u5904\u767b\u5f55\uff0c\u8bf7\u60a8\u4fee\u6539\u5bc6\u7801\u6216\u91cd\u65b0\u767b\u5f55");
            ServletUtils.renderString((HttpServletResponse)res, (String)objectMapper.writeValueAsString(data));
        } else {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.kickoutUrl);
        }
        return false;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(this.getCACHE_PREFIX());
    }

    @Generated
    public KickoutSessionFilter() {
    }

    @Generated
    public Boolean getKickoutAfter() {
        return this.kickoutAfter;
    }

    @Generated
    public String getCACHE_PREFIX() {
        return this.CACHE_PREFIX;
    }

    @Generated
    public String getKickoutUrl() {
        return this.kickoutUrl;
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Generated
    public Cache<String, Deque<Serializable>> getCache() {
        return this.cache;
    }

    @Generated
    public List<String> getMultiAccountLoginAccountList() {
        return this.multiAccountLoginAccountList;
    }

    @Generated
    public void setKickoutAfter(Boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    @Generated
    public void setCACHE_PREFIX(String CACHE_PREFIX) {
        this.CACHE_PREFIX = CACHE_PREFIX;
    }

    @Generated
    public void setKickoutUrl(String kickoutUrl) {
        this.kickoutUrl = kickoutUrl;
    }

    @Generated
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Generated
    public void setCache(Cache<String, Deque<Serializable>> cache) {
        this.cache = cache;
    }

    @Generated
    public void setMultiAccountLoginAccountList(List<String> multiAccountLoginAccountList) {
        this.multiAccountLoginAccountList = multiAccountLoginAccountList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KickoutSessionFilter)) {
            return false;
        }
        KickoutSessionFilter other = (KickoutSessionFilter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$kickoutAfter = this.getKickoutAfter();
        Boolean other$kickoutAfter = other.getKickoutAfter();
        if (this$kickoutAfter == null ? other$kickoutAfter != null : !((Object)this$kickoutAfter).equals(other$kickoutAfter)) {
            return false;
        }
        String this$CACHE_PREFIX = this.getCACHE_PREFIX();
        String other$CACHE_PREFIX = other.getCACHE_PREFIX();
        if (this$CACHE_PREFIX == null ? other$CACHE_PREFIX != null : !this$CACHE_PREFIX.equals(other$CACHE_PREFIX)) {
            return false;
        }
        String this$kickoutUrl = this.getKickoutUrl();
        String other$kickoutUrl = other.getKickoutUrl();
        if (this$kickoutUrl == null ? other$kickoutUrl != null : !this$kickoutUrl.equals(other$kickoutUrl)) {
            return false;
        }
        SessionManager this$sessionManager = this.getSessionManager();
        SessionManager other$sessionManager = other.getSessionManager();
        if (this$sessionManager == null ? other$sessionManager != null : !this$sessionManager.equals(other$sessionManager)) {
            return false;
        }
        Cache<String, Deque<Serializable>> this$cache = this.getCache();
        Cache<String, Deque<Serializable>> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        List<String> this$multiAccountLoginAccountList = this.getMultiAccountLoginAccountList();
        List<String> other$multiAccountLoginAccountList = other.getMultiAccountLoginAccountList();
        return !(this$multiAccountLoginAccountList == null ? other$multiAccountLoginAccountList != null : !((Object)this$multiAccountLoginAccountList).equals(other$multiAccountLoginAccountList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KickoutSessionFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $kickoutAfter = this.getKickoutAfter();
        result = result * 59 + ($kickoutAfter == null ? 43 : ((Object)$kickoutAfter).hashCode());
        String $CACHE_PREFIX = this.getCACHE_PREFIX();
        result = result * 59 + ($CACHE_PREFIX == null ? 43 : $CACHE_PREFIX.hashCode());
        String $kickoutUrl = this.getKickoutUrl();
        result = result * 59 + ($kickoutUrl == null ? 43 : $kickoutUrl.hashCode());
        SessionManager $sessionManager = this.getSessionManager();
        result = result * 59 + ($sessionManager == null ? 43 : $sessionManager.hashCode());
        Cache<String, Deque<Serializable>> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        List<String> $multiAccountLoginAccountList = this.getMultiAccountLoginAccountList();
        result = result * 59 + ($multiAccountLoginAccountList == null ? 43 : ((Object)$multiAccountLoginAccountList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KickoutSessionFilter(kickoutAfter=" + this.getKickoutAfter() + ", CACHE_PREFIX=" + this.getCACHE_PREFIX() + ", kickoutUrl=" + this.getKickoutUrl() + ", sessionManager=" + String.valueOf(this.getSessionManager()) + ", cache=" + String.valueOf(this.getCache()) + ", multiAccountLoginAccountList=" + String.valueOf(this.getMultiAccountLoginAccountList()) + ")";
    }
}

