package cn.smarthse.web.common.util;

import org.springframework.web.multipart.MultipartFile;

import java.io.*;

/**
 * @author 邓力宾
 * @date 2020-08-07 12:11
 * @desc
 */
public class UploadFileUtils {
    private UploadFileUtils(){}

    /**
     * 复制上传的文件 到指定文件路径
     * @param fileIn
     * @param fileOut
     * @throws IOException
     */
    public static  void copyFile(MultipartFile fileIn, File fileOut) throws IOException {
        File parentFile = fileOut.getParentFile();
        if(!parentFile.exists()){
            boolean mkdirs = parentFile.mkdirs();
            if(!mkdirs){
                throw new RuntimeException("创建文件失败:"+parentFile.getAbsolutePath());
            }
        }
        if(!fileOut.exists()){
            boolean r = fileOut.createNewFile();
            if(!r){
                throw new RuntimeException("创建文件失败:"+fileOut.getAbsolutePath());
            }
        }
        BufferedInputStream bufi = new BufferedInputStream(fileIn.getInputStream());
        BufferedOutputStream bufo = new BufferedOutputStream(new FileOutputStream(fileOut,false));
        byte[] buffer= new byte[1024];
        int len;
        while((len = bufi.read(buffer)) > 0){
            bufo.write(buffer, 0, len);
        }
        bufo.close();
        bufi.close();
    }

}
