package cn.smarthse.web.common.util;


import cn.smarthse.web.common.exception.FieldValueIllegalException;
import org.springframework.beans.BeanUtils;

import java.beans.PropertyDescriptor;


/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 字段检查工具类
 * @since 2020/3/17 0017 16:55
 */
public class FieldCheckUtils {

    private FieldCheckUtils(){}
    /**
     * 空字段检查
     * @param javaBean
     * @param propertyNames
     * @throws Exception
     */
    public static void checkEmptyFields(Object javaBean, String... propertyNames) throws FieldValueIllegalException {
        for (String fieldName : propertyNames) {
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(javaBean.getClass(), fieldName);
            Object result = null;
            try {
                result = propertyDescriptor.getReadMethod().invoke(javaBean );
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            if(result == null){
                throw new FieldValueIllegalException(fieldName+"不能为空");
            }
            if(result instanceof  String){
                if(((String) result).length() == 0){
                    throw new FieldValueIllegalException(fieldName+"不能为空");
                }
            }
        }
    }

    /**
     * 参数值合法性检测
     * @param javaBean
     * @param propertyName 属性名
     * @param legalValues 该属性 合法值
     * @throws Exception
     */
    public static void checkIllegalValue(Object javaBean, String propertyName, Object... legalValues) throws FieldValueIllegalException {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(javaBean.getClass(), propertyName);
        Object result = null;
        try {
            result = propertyDescriptor.getReadMethod().invoke(javaBean );
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Object legalValue : legalValues) {
            if(legalValue.equals(result)){
                return;
            }
        }
        throw new FieldValueIllegalException(propertyName+"字段值非法");

    }

}
