package cn.smarthse.web.common.model;
import cn.smarthse.web.common.enums.StatusCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 接口统一返回对象
 * @since 2020/3/12 0012 15:02
 */
@Data
@ApiModel("接口统一返回对象")
public class ResponseData<T> {

    @ApiModelProperty(value = "结果码", required = true, example = "1")
    private Integer code; // 结果码
    @ApiModelProperty(value = "提示信息", required = false)
    private String msg; // 提示信息
    @ApiModelProperty(value = "结果数据", required = false)
    private T data; // 结果数据
    // 写一个空参数的构造函数，用于反序列化
    public ResponseData(){

    }
    private ResponseData(StatusCodeEnum codeEnum, T data){
        this.code = codeEnum.getCode();
        this.msg = codeEnum.getMsg();
        this.data = data;
    }
    private ResponseData(int code, String msg, T data){
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
    /**
     * 成功
     * @param data
     * @param <W>
     * @return
     */
    public static <W>ResponseData<W> success(W data){
        return new ResponseData<>(StatusCodeEnum.SUCCESS, data );
    }
   /**
     * 失败
     * @param msg
     * @return
     */
    public static<T> ResponseData<T> fail(String msg){
        return new ResponseData<>(StatusCodeEnum.FAIL.getCode(), msg, null );
    }
    public static<T> ResponseData<T> fail(String msg, T data){
        return new ResponseData<>(StatusCodeEnum.FAIL.getCode(), msg, data );
    }
    /**
     * 服务端异常
     * @param msg
     * @return
     */
    public static<T> ResponseData<T> error(String msg){
        return new ResponseData<>(StatusCodeEnum.ERROR.getCode(), msg, null );
    }

    /**
     * 请求错误
     * @param
     * @return
     */
    public static ResponseData<Object> requestError(){
        return new ResponseData<>(StatusCodeEnum.REQUEST_ERROR, null );
    }

    /**
     * 请求错误
     * @param msg 提示信息
     * @return
     */
    public static <T>ResponseData<T> requestError(String msg){
        return new ResponseData<>(StatusCodeEnum.REQUEST_ERROR.getCode(), msg,null );
    }


    /**
     * 禁止访问错误
     * @return
     */
    public static ResponseData<Object> forbiddenError(){
        return new ResponseData<>(StatusCodeEnum.FORBIDDEN_ERROR,null );
    }
    /**
     * 账号在其他地方登录
     * @return
     */
    public static ResponseData<Object> forceOffline(){
        return new ResponseData<>(StatusCodeEnum.FORCE_OFFLINE,null );
    }
    /**
     * session 失效（过期或被强制下线）
     * @return
     */
    public static ResponseData<Object> invalidSession(){
        return new ResponseData<>(StatusCodeEnum.INVALID_SESSION,null );
    }

    /**
     * 登录失败-用户名或密码错误
     * @return
     */
    public static ResponseData<Object> loginFail(){
        return new ResponseData<>(StatusCodeEnum.FAIL.getCode(), "登录失败请检查用户名密码",null );
    }
  /**
     * 登录失败-验证码错误
     * @return
     */
    public static ResponseData<Object> verCodeError(){
        return new ResponseData<>(StatusCodeEnum.FAIL.getCode(), "验证码错误或已失效",null );
    }

    /**
     * 未登录
     * @return
     */
    public static ResponseData<Object> noLogin() {
        return new ResponseData<>(StatusCodeEnum.NO_LOGIN,null );
    }
}
