package cn.smarthse.web.common.enums;

import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 接口返回状态码和提示信息枚举
 * @since 2020/3/12 0012 15:12
 */
@JSONType(writeEnumAsJavaBean=true)
public enum StatusCodeEnum {

    ERROR(500, "服务端异常"), // 程序员处理（正常情况下不应该有该错误）

    SUCCESS(0, "成功"),
    
    FAIL(1, "失败"), // 前端可以直接展示返回提示信息给用户
	
	NO_LOGIN(3, "未登录认证"), // 用户未登录

    REQUEST_ERROR(400, "请求参数错误"), // 由程序员处理

    FORBIDDEN_ERROR(403, "无权限，禁止访问"), // 无权限访问的接口，由程序员处理（对于无权限的资源页面上不应设置访问入口）

    FORCE_OFFLINE(405, "账号在其他地方登录或被强制下线"), // 由程序员处理（如 弹框提示）

    INVALID_SESSION(406, "会话过期,登录失效");// 由程序员处理（如 弹框提示）

    private int code; //状态码
    private String msg; //提示信息

    StatusCodeEnum(int code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
