/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.util.common.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager cm;
    private static CloseableHttpClient closeableHttpClientClient;
    private static SocketConfig socketConfig;
    private static HttpHost proxy;
    private static String defaultUserAgent;

    public static String doGet(String url, Map<String, String> param) {
        String resultString = null;
        CloseableHttpResponse response = null;
        long startTime = System.currentTimeMillis();
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            response = closeableHttpClientClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            httpGet.releaseConnection();
            return resultString;
        }
        catch (SocketTimeoutException e) {
            long costTime = System.currentTimeMillis() - startTime;
            log.warn("HTTP\u8bf7\u6c42\u8d85\u65f6, url: {}, \u53c2\u6570: {}, \u8d85\u65f6\u65f6\u95f4: {}ms", new Object[]{url, param, costTime, e});
        }
        catch (ConnectException e) {
            log.error("\u8fde\u63a5\u88ab\u62d2\u7edd, url: {}, \u53c2\u6570: {}", new Object[]{url, param, e});
        }
        catch (IOException e) {
            log.error("\u7f51\u7edcIO\u5f02\u5e38, url: {}, \u53c2\u6570: {}", new Object[]{url, param, e});
        }
        catch (Exception e) {
            log.error("\u672a\u77e5\u5f02\u5e38, url: {}, \u53c2\u6570: {}", new Object[]{url, param, e});
        }
        return resultString;
    }

    public static String doPost(String url, Map<String, String> param, String responseCharset, Map<String, String> headers) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList paramList = new ArrayList();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((List)paramList, "utf-8");
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            response = closeableHttpClientClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)responseCharset);
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    public static String doPostString(String url, String body, Map<String, String> headers, String responseCharset) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setEntity((HttpEntity)new StringEntity(body, responseCharset));
            response = closeableHttpClientClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)responseCharset);
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    public static String getFileName(HttpResponse response) {
        NameValuePair param;
        HeaderElement[] values;
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null && (values = contentHeader.getElements()).length == 1 && (param = values[0].getParameterByName("filename")) != null) {
            try {
                filename = param.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }

    public static void main(String[] args) {
        String url = "http://www.aoshan-academy.com/asxypxserver/rest/pxxmsbTask/callBack";
        JSONArray jsonArray = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("companyCode", (Object)"33029102121");
        obj.put("isCorrect", (Object)0);
        jsonArray.add((Object)obj);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("callBackVoList", (Object)jsonArray);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String s = HttpUtil.doPostString(url, JSON.toJSONString((Object)jsonObject), headers, "utf-8");
        System.out.println(s);
    }

    static {
        defaultUserAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.59 Safari/537.36";
        cm = new PoolingHttpClientConnectionManager();
        socketConfig = SocketConfig.custom().setSoKeepAlive(true).build();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(100);
        cm.setDefaultSocketConfig(socketConfig);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm);
        httpClientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy());
        closeableHttpClientClient = httpClientBuilder.build();
    }
}

