/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.util.common.http;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpConnectionPoolManager {
    private static HttpConnectionPoolManager manager = new HttpConnectionPoolManager();
    private PoolingHttpClientConnectionManager cm;
    private PoolingHttpClientConnectionManager sslCm;
    private SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).build();
    private ConnectionConfig connectionConfig = ConnectionConfig.DEFAULT;
    private int connection_pool = 100;
    private int route_num = 1000;
    private SSLContext sslcontext;
    private SSLConnectionSocketFactory sslsf;
    private Registry<ConnectionSocketFactory> registry;
    private HttpHost proxy;

    public HttpConnectionPoolManager() {
        try {
            this.sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new org.apache.http.conn.ssl.TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            this.sslsf = new SSLConnectionSocketFactory(this.sslcontext, new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)this.sslsf).build();
            this.cm = new PoolingHttpClientConnectionManager(this.registry);
            this.cm.setMaxTotal(this.connection_pool);
            this.cm.setDefaultMaxPerRoute(this.route_num);
            this.cm.setDefaultSocketConfig(this.socketConfig);
            this.cm.setValidateAfterInactivity(200);
            this.cm.setDefaultConnectionConfig(this.connectionConfig);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static HttpConnectionPoolManager getInstance() {
        return manager;
    }

    public PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
        return this.cm;
    }

    public void closeExpiredConnections() {
        this.cm.closeExpiredConnections();
    }

    public void closeIdleConnections(int seconds) {
        this.cm.closeIdleConnections((long)seconds, TimeUnit.SECONDS);
    }
}

