/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.util.common.excel;

import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.util.common.excel.model.ColumnExportModel;
import cn.smarthse.util.common.excel.model.ExcelExportModel;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.RowModel2;
import cn.smarthse.util.common.excel.model.SheetData;
import cn.smarthse.util.common.excel.model.SheetExportModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.Assert;

public class ExcelUtils {
    private static NumberFormat nf = NumberFormat.getInstance();

    private ExcelUtils() {
    }

    public static List<String> getXlsSheetNames(InputStream inputStream) throws IOException {
        ArrayList<String> list = new ArrayList<String>(16);
        POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
        int numberOfSheets = hssfWorkbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
            list.add(sheet.getSheetName());
        }
        poifsFileSystem.close();
        inputStream.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelModel parseXls(InputStream inputStream, int ... cellNums) {
        ExcelModel excelModel = new ExcelModel();
        LinkedList<SheetModel> sheetModels = new LinkedList<SheetModel>();
        excelModel.setSheets(sheetModels);
        try {
            POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
            int numberOfSheets = hssfWorkbook.getNumberOfSheets();
            for (int i = 0; i < numberOfSheets; ++i) {
                HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
                if (sheet == null) continue;
                SheetModel sheetModel = new SheetModel();
                sheetModels.add(sheetModel);
                sheetModel.setSheetName(sheet.getSheetName());
                sheetModel.setRows(new LinkedList<RowModel>());
                int rowNum = sheet.getLastRowNum();
                for (int j = 0; j <= rowNum; ++j) {
                    HSSFRow row = sheet.getRow(j);
                    if (row == null) continue;
                    RowModel rowModel = new RowModel();
                    if (j == 0) {
                        sheetModel.setHeaders(rowModel);
                    }
                    boolean isAllCellEmpty = true;
                    for (int k = 0; k < cellNums[i]; ++k) {
                        HSSFCell cell = row.getCell(k);
                        if (cell != null) {
                            String stringCellValue = "";
                            if (ExcelUtils.isMergedRegion((Sheet)sheet, j, k)) {
                                stringCellValue = ExcelUtils.getMergedRegionValue((Sheet)sheet, j, k);
                            } else {
                                cell.setCellType(CellType.STRING);
                                stringCellValue = cell.getStringCellValue();
                            }
                            if (stringCellValue.length() > 0) {
                                isAllCellEmpty = false;
                            }
                            rowModel.add(stringCellValue.trim());
                            continue;
                        }
                        rowModel.add("");
                    }
                    if (isAllCellEmpty || j <= 0) continue;
                    sheetModel.getRows().add(rowModel);
                    RowModel2 rowModel2 = new RowModel2();
                    rowModel2.setRowNum(j + 1);
                    rowModel2.setCol(rowModel);
                    sheetModel.getRows2().add(rowModel2);
                }
            }
            poifsFileSystem.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return excelModel;
    }

    private static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return ExcelUtils.getCellValue(fCell);
        }
        return null;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        cell.setCellType(CellType.STRING);
        return cell.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelModel parseXlsx(InputStream inputStream, int ... cellNums) {
        ExcelModel excelModel = new ExcelModel();
        LinkedList<SheetModel> sheetModels = new LinkedList<SheetModel>();
        excelModel.setSheets(sheetModels);
        try {
            XSSFWorkbook xwb = new XSSFWorkbook(inputStream);
            for (int numSheet = 0; numSheet < xwb.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xSheet = xwb.getSheetAt(numSheet);
                if (xSheet == null) continue;
                SheetModel sheetModel = new SheetModel();
                sheetModels.add(sheetModel);
                sheetModel.setSheetName(xSheet.getSheetName());
                LinkedList<RowModel> rowModels = new LinkedList<RowModel>();
                sheetModel.setRows(rowModels);
                for (int numRow = 0; numRow <= xSheet.getLastRowNum(); ++numRow) {
                    XSSFRow xRow = xSheet.getRow(numRow);
                    if (xRow == null) continue;
                    RowModel rowModel = new RowModel();
                    if (numRow == 0) {
                        sheetModel.setHeaders(rowModel);
                    }
                    boolean isAllCellEmpty = true;
                    for (int numCell = 0; numCell < cellNums[numSheet]; ++numCell) {
                        XSSFCell xCell = xRow.getCell(numCell);
                        String value = ExcelUtils.getValue(xCell);
                        if (value != null && value.length() > 0) {
                            isAllCellEmpty = false;
                        }
                        rowModel.add(value);
                    }
                    if (isAllCellEmpty || numRow <= 0) continue;
                    sheetModel.getRows().add(rowModel);
                }
            }
            xwb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return excelModel;
    }

    private static String getValue(XSSFCell xCell) {
        if (xCell == null) {
            return "";
        }
        if (xCell.getCellTypeEnum() == CellType.BOOLEAN) {
            return String.valueOf(xCell.getBooleanCellValue());
        }
        if (xCell.getCellTypeEnum() == CellType.NUMERIC) {
            double numericCellValue = xCell.getNumericCellValue();
            return nf.format(numericCellValue);
        }
        return String.valueOf(xCell.getStringCellValue());
    }

    public static void exportXls(OutputStream outputStream, ExcelExportModel excelExportModel) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        for (SheetExportModel sheetModel : excelExportModel.getSheets()) {
            HSSFSheet sheet = workbook.createSheet(sheetModel.getSheetName());
            sheet.setColumnWidth(0, 3840);
            List<ColumnExportModel> columnExportModelList = sheetModel.getColumnExportModelList();
            int rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < columnExportModelList.size(); ++i) {
                ColumnExportModel columnExportModel = columnExportModelList.get(i);
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(columnExportModel.getHeaderName());
            }
            List<Object> dataList = sheetModel.getDataList();
            if (dataList == null || dataList.isEmpty()) continue;
            for (Object o : dataList) {
                row = sheet.createRow(rowNum++);
                for (int i = 0; i < columnExportModelList.size(); ++i) {
                    ColumnExportModel columnExportModel = columnExportModelList.get(i);
                    HSSFCell cell = row.createCell(i);
                    String propertyName = columnExportModel.getPropertyName();
                    String firstChar = propertyName.substring(0, 1).toUpperCase();
                    Method getMethod = o.getClass().getMethod("get" + firstChar + propertyName.substring(1), new Class[0]);
                    Object result = getMethod.invoke(o, new Object[0]);
                    cell.setCellValue(ExcelUtils.formatToString(result));
                }
            }
        }
        workbook.write(outputStream);
        workbook.close();
        outputStream.close();
    }

    public static void exportSingleSheet(OutputStream outputStream, List<Object> dataList, String columnHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        String[] columnHeaderArr;
        Assert.notNull((Object)columnHeaders, (String)"\u5bfc\u51fa\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        ExcelExportModel excelExportModel = new ExcelExportModel();
        excelExportModel.setSheets(new ArrayList<SheetExportModel>());
        excelExportModel.getSheets().add(new SheetExportModel());
        SheetExportModel sheetExportModel = excelExportModel.getSheets().get(0);
        sheetExportModel.setSheetName("sheet1");
        sheetExportModel.setDataList(dataList);
        sheetExportModel.setColumnExportModelList(new ArrayList<ColumnExportModel>());
        List<ColumnExportModel> columnExportModelList = sheetExportModel.getColumnExportModelList();
        for (String columnHeader : columnHeaderArr = columnHeaders.split(",")) {
            String[] strings = columnHeader.split("\\|");
            columnExportModelList.add(new ColumnExportModel(strings[0].trim(), strings[1].trim()));
        }
        ExcelUtils.exportXls(outputStream, excelExportModel);
    }

    private static String formatToString(Object o) {
        if (o instanceof Date) {
            return DateUtils.format((Date)o, "yyyy-MM-dd HH:mm:ss");
        }
        if (o instanceof Double) {
            return nf.format((Double)o);
        }
        if (o instanceof LocalDateTime) {
            return DateUtils.formatDate((LocalDateTime)o);
        }
        return String.valueOf(o);
    }

    public static void exportXlsByModel(OutputStream outputStream, InputStream xlsModelInputStream, Map<String, SheetData> sheetDataMap) throws IOException {
        ExcelUtils.exportXlsByModel(outputStream, xlsModelInputStream, sheetDataMap, null);
    }

    public static void exportXlsByModel(OutputStream outputStream, InputStream xlsModelInputStream, Map<String, SheetData> sheetDataMap, Consumer<HSSFSheet> consumer) throws IOException {
        POIFSFileSystem poifsFileSystem = new POIFSFileSystem(xlsModelInputStream);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
        int numberOfSheets = hssfWorkbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            SheetData excelDataMode2;
            HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
            if (sheet == null) continue;
            String sheetName = sheet.getSheetName();
            if (sheetDataMap != null && (excelDataMode2 = sheetDataMap.get(sheetName)) != null) {
                int startRow = excelDataMode2.getStartRow();
                List<List<String>> dataList = excelDataMode2.getDataList();
                if (dataList != null) {
                    for (List<String> rowList : dataList) {
                        HSSFRow row = sheet.createRow(startRow++);
                        for (int j = 0; j < rowList.size(); ++j) {
                            HSSFCell cell = row.createCell(j);
                            cell.setCellValue(rowList.get(j));
                        }
                    }
                }
            }
            if (consumer == null) continue;
            consumer.accept(sheet);
        }
        hssfWorkbook.write(outputStream);
        outputStream.close();
        xlsModelInputStream.close();
    }

    public static Map<Integer, List<HSSFShape>> arrangeXlsImg(InputStream inputStream, int col) throws IOException {
        try (HSSFWorkbook workbook = new HSSFWorkbook(inputStream);){
            HSSFSheet sheet = workbook.getSheetAt(0);
            HSSFPatriarch drawing = sheet.getDrawingPatriarch();
            HashMap<Integer, List<HSSFShape>> siteImgMap = new HashMap<Integer, List<HSSFShape>>();
            if (drawing != null) {
                drawing.getChildren().stream().filter(shape -> shape instanceof HSSFPicture).map(shape -> (HSSFPicture)shape).filter(shape -> ((HSSFClientAnchor)shape.getAnchor()).getCol1() == col).forEach(shape -> {
                    int row = ((HSSFClientAnchor)shape.getAnchor()).getRow1();
                    siteImgMap.computeIfAbsent(row, k -> new ArrayList()).add(shape);
                });
            }
            HashMap<Integer, List<HSSFShape>> hashMap = siteImgMap;
            return hashMap;
        }
    }

    public static Map<Integer, List<XSSFShape>> arrangeXlsxImg(InputStream inputStream, int col) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook(inputStream);){
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFDrawing drawing = sheet.getDrawingPatriarch();
            HashMap<Integer, List<XSSFShape>> siteImgMap = new HashMap<Integer, List<XSSFShape>>();
            if (drawing != null) {
                drawing.getShapes().stream().filter(shape -> shape instanceof XSSFPicture).map(shape -> (XSSFPicture)shape).filter(shape -> ((XSSFClientAnchor)shape.getAnchor()).getCol1() == col).forEach(shape -> {
                    int row = ((XSSFClientAnchor)shape.getAnchor()).getRow1();
                    siteImgMap.computeIfAbsent(row, k -> new ArrayList()).add(shape);
                });
            }
            HashMap<Integer, List<XSSFShape>> hashMap = siteImgMap;
            return hashMap;
        }
    }

    static {
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
    }
}

