/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.util.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ListUtils {
    public static <T> List<List<T>> split(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    public static <T> List<T> delRepeat(List<T> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }

    public static <T> List<T> deduplicateByExcludeFields(List<T> list, List<String> ignoreFields) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(ignoreFields)) {
            return list;
        }
        return list.stream().filter(ListUtils.distinctByExcludedKeys(ignoreFields)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByExcludedKeys(List<String> ignoreFields) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> {
            try {
                Object key = ListUtils.generateKey(t, ignoreFields);
                return seen.putIfAbsent(key, Boolean.TRUE) == null;
            }
            catch (Exception e) {
                throw new RuntimeException("\u53bb\u91cd\u952e\u751f\u6210\u5931\u8d25", e);
            }
        };
    }

    private static Object generateKey(Object obj, List<String> ignoreFields) throws Exception {
        List<Field> fields = ListUtils.getAllFields(obj.getClass());
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : fields) {
            if (ignoreFields.contains(field.getName())) continue;
            field.setAccessible(true);
            Object value = field.get(obj);
            values.add(value != null ? value : "NULL");
        }
        return Arrays.deepHashCode(values.toArray());
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

