/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.util.common.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpsUtil {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static SSLContextBuilder builder = null;
    private static RequestConfig config;
    private static CloseableHttpClient httpClient;
    private static KeyStore keyStore;
    private static SSLContext sslcontext;
    private static HttpRequestRetryHandler httpRequestRetryHandler;

    public static HttpClient getMyHttpsClient() {
        return httpClient;
    }

    public static String postWebservice(String url, Map<String, String> header, String StringEntity2) throws Exception {
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setEntity((HttpEntity)new StringEntity(StringEntity2, "utf-8"));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            httpResponse.close();
            httpPost.releaseConnection();
            return body;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static String get(String url) {
        Object result = null;
        try {
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            httpResponse.close();
            httpget.releaseConnection();
            return body;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String get(String url, Map<String, String> headers) {
        Object result = null;
        try {
            HttpGet httpget = new HttpGet(url);
            if (headers != null && headers.size() != 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpget.setHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            httpResponse.close();
            httpget.releaseConnection();
            return body;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String doGet(String url, Map<String, String> param, String charset) {
        String resultString = null;
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            response = httpClient.execute((HttpUriRequest)httpGet);
            System.out.println(uri);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            httpGet.releaseConnection();
            return resultString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return resultString;
        }
    }

    public static String doPost(String url, String body, String responseCharset, Map<String, String> headers) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setEntity((HttpEntity)new StringEntity(body, responseCharset));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)responseCharset);
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    public static String readHttpResponse(HttpResponse httpResponse) throws ParseException, IOException {
        StringBuilder builder = new StringBuilder();
        HttpEntity entity = httpResponse.getEntity();
        builder.append("status:" + httpResponse.getStatusLine());
        builder.append("headers:");
        HeaderIterator iterator = httpResponse.headerIterator();
        while (iterator.hasNext()) {
            builder.append("\t" + iterator.next());
        }
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            builder.append("response length:" + responseString.length());
            builder.append("response content:" + responseString.replace("\r\n", ""));
        }
        return builder.toString();
    }

    public static String soap(String url, String soapRequetData) {
        String resultString = null;
        try {
            HttpPost post = new HttpPost(url);
            post.setEntity((HttpEntity)new StringEntity(soapRequetData, "utf-8"));
            post.setHeader("Content-Type", "text/xml; charset=utf-8 ");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            response.close();
            post.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    static {
        httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 2) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return false;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        config = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(1000).build();
        try {
            builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register(HTTP, (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)sslsf).build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(2000);
            cm.setDefaultMaxPerRoute(200);
            cm.setDefaultConnectionConfig(ConnectionConfig.DEFAULT);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).setDefaultRequestConfig(config).setRetryHandler(httpRequestRetryHandler).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

