package cn.smarthse.util.common.http;

import org.apache.http.*;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.CookieSpecs;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

/**
 * 用于https请求
 * Created by denglibin on 17-6-18.
 */
public class HttpsUtil {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static SSLContextBuilder builder = null;
    private static RequestConfig config;
    private static CloseableHttpClient httpClient;
    private static KeyStore keyStore;
    private static SSLContext sslcontext;
    //请求重试处理
    private static HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler() {
        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= 2) {// 如果已经重试了2次，就放弃
                return false;
            }
            if (exception instanceof NoHttpResponseException) {// 如果服务器丢掉了连接，那么就重试
                return false;
            }
            if (exception instanceof SSLHandshakeException) {// 不要重试SSL握手异常
                return false;
            }
            if (exception instanceof InterruptedIOException) {// 重试
                //重试
                return true;
            }
            if (exception instanceof UnknownHostException) {// 目标服务器不可达
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {// 超时
                return false;
            }
            if (exception instanceof SSLException) {// ssl握手异常
                return false;
            }

            HttpClientContext clientContext = HttpClientContext.adapt(context);
            HttpRequest request = clientContext.getRequest();
            // 如果请求是幂等的，就再次尝试
            if (!(request instanceof HttpEntityEnclosingRequest)) {
                return true;
            }
            return false;
        }

    };

    static {
        try {
            //   keyStore = KeyStore.getInstance("PKCS12");
            sslcontext = SSLContexts.custom()
                    //忽略掉对服务器端证书的校验
                    .loadTrustMaterial(new TrustStrategy() {
                        @Override
                        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            return true;
                        }
                    })
                    // .loadKeyMaterial()加载客户端证书
                    //加载服务端提供的truststore(如果服务器提供truststore的话就不用忽略对服务器端证书的校验了)
                    //.loadTrustMaterial(new File("D:\\truststore.jks"), "123456".toCharArray(),
                    //        new TrustSelfSignedStrategy())
                    //  .loadKeyMaterial(keyStore, "cmcc".toCharArray())
                    .build();
        } catch (Exception e) {
            e.printStackTrace();
        }

        config = RequestConfig
                .custom()
                .setCookieSpec(CookieSpecs.STANDARD_STRICT)
                .setConnectTimeout(1000)
                .setConnectionRequestTimeout(1000)
                .setSocketTimeout(1000)
                .build();
        try {
            builder = new SSLContextBuilder();
            // 全部信任 不做身份鉴定
            builder.loadTrustMaterial(null, new TrustStrategy() {
                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            //如果要使用证书将 builer.build（）改为 sslcontext,并设置信任策略
            sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, NoopHostnameVerifier.INSTANCE);
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
                    .register(HTTP, new PlainConnectionSocketFactory())
                    .register(HTTPS, sslsf)
                    .build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(2000);//max connection
            cm.setDefaultMaxPerRoute(200);
            cm.setDefaultConnectionConfig(ConnectionConfig.DEFAULT);
            httpClient = HttpClients.custom()
                    .setSSLSocketFactory(sslsf)
                    .setConnectionManager(cm)
                    .setConnectionManagerShared(true)
                    .setDefaultRequestConfig(config)
                    .setRetryHandler(httpRequestRetryHandler)
                    .build();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HttpsUtil() throws KeyStoreException {
    }

    public static HttpClient getMyHttpsClient() {
        return httpClient;
    }

    public static String postWebservice(String url, Map<String, String> header, String StringEntity) throws Exception {
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            // 设置头信息
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());

                }
            }
            httpPost.setEntity(new StringEntity(StringEntity, "utf-8"));
            CloseableHttpResponse httpResponse = httpClient.execute(httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();

            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString(httpEntity, "UTF-8");
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            httpResponse.close();
            //释放连接
            httpPost.releaseConnection();
            return body;

        } catch (Exception e) {
            e.printStackTrace();

        }
        return result;
    }

    public static String get(String url) {
        String result = null;
        try {
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse httpResponse = httpClient.execute(httpget);
            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString(httpEntity, "UTF-8");
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            httpResponse.close();
            //释放连接
            httpget.releaseConnection();
            return body;

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String get(String url, Map<String, String> headers) {
        String result = null;
        try {
            HttpGet httpget = new HttpGet(url);
            // 设置头信息
            if (headers != null && headers.size() != 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpget.setHeader(entry.getKey(), entry.getValue());

                }
            }
            CloseableHttpResponse httpResponse = httpClient.execute(httpget);
            HttpEntity httpEntity = httpResponse.getEntity();
            String body = EntityUtils.toString(httpEntity, "UTF-8");
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            httpResponse.close();
            //释放连接
            httpget.releaseConnection();
            return body;

        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }


    /**
     * get请求(参数可以为null)
     *
     * @param url
     * @param param
     * @return
     */
    public static String doGet(String url, Map<String, String> param, String charset) {
        String resultString = null;
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            // 创建http GET请求
            HttpGet httpGet = new HttpGet(uri);
            // 执行请求
            response = httpClient.execute(httpGet);
            System.out.println(uri);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString(httpEntity, charset);
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            httpGet.releaseConnection();
            return resultString;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    /**
     * post请求 参数可为null
     *
     * @param url
     * @param body
     * @return
     */
    public static String doPost(String url, String body, String responseCharset, Map<String, String> headers) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    //httpPost.setHeader("Content-Type","application/json;charset=utf-8");
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            // 执行http请求
            httpPost.setEntity(new StringEntity(body, responseCharset));
            response = httpClient.execute(httpPost);
           /*
            StatusLine statusLine = response.getStatusLine();
            Header[] allHeaders = response.getAllHeaders();
            LogUtil.info("状态码："+statusLine.getStatusCode());
            for(Header header : allHeaders){
                LogUtil.info(header.getName()+"-->"+header.getValue());
            }
            */
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString(httpEntity, responseCharset);
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            httpPost.releaseConnection();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return resultString;
    }

    public static String readHttpResponse(HttpResponse httpResponse)
            throws ParseException, IOException {
        StringBuilder builder = new StringBuilder();
        // 获取响应消息实体
        HttpEntity entity = httpResponse.getEntity();
        // 响应状态
        builder.append("status:" + httpResponse.getStatusLine());
        builder.append("headers:");
        HeaderIterator iterator = httpResponse.headerIterator();
        while (iterator.hasNext()) {
            builder.append("\t" + iterator.next());
        }
        // 判断响应实体是否为空
        if (entity != null) {
            String responseString = EntityUtils.toString(entity);
            builder.append("response length:" + responseString.length());
            builder.append("response content:" + responseString.replace("\r\n", ""));
        }
        return builder.toString();
    }

    public static String soap(String url, String soapRequetData) {
        String resultString = null;
        try {
            HttpPost post = new HttpPost(url);
            post.setEntity(new StringEntity(soapRequetData, "utf-8"));
            post.setHeader("Content-Type", "text/xml; charset=utf-8 ");
            CloseableHttpResponse response = httpClient.execute(post);
            HttpEntity httpEntity = response.getEntity();
            resultString = EntityUtils.toString(httpEntity, "UTF-8");
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            post.releaseConnection();
        } catch (Exception e) {
            e.printStackTrace();

        }
        return resultString;
    }
}
