package cn.smarthse.util.common.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.http.*;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 简单http请求工具类
 * Created by DengLibin on 2017/5/26.
 */
public class HttpUtil {
    private static PoolingHttpClientConnectionManager cm;
    private static CloseableHttpClient closeableHttpClientClient;
    private static SocketConfig socketConfig;
    private static HttpHost proxy;
    private static String defaultUserAgent =  "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.59 Safari/537.36";
    static{
        cm = new PoolingHttpClientConnectionManager();
        socketConfig = SocketConfig.custom().setSoKeepAlive(true).build();
        cm.setMaxTotal(100);// 整个连接池最大连接数
        cm.setDefaultMaxPerRoute(100);// 每路由最大连接数，默认值是2
        cm.setDefaultSocketConfig(socketConfig);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(cm);

            //设置代理
            //proxy = new HttpHost("127.0.0.1",8888);
          //  httpClientBuilder.setProxy(proxy);
        //使用长连接(默认的长连接策略)
        httpClientBuilder.setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy());

         closeableHttpClientClient = httpClientBuilder.build();
    }


    /**
     * get请求(参数可以为null)
     * @param url
     * @param param
     * @return
     */
    public static String doGet(String url, Map<String, String> param) {
        String resultString = null;
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();

            // 创建http GET请求
            HttpGet httpGet = new HttpGet(uri);

            // 执行请求
            response = closeableHttpClientClient.execute(httpGet);
            HttpEntity httpEntity =  response.getEntity();
            // 判断返回状态是否为200
            if (response.getStatusLine().getStatusCode() == 200) {

                resultString = EntityUtils.toString(httpEntity, "UTF-8");
            }

            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            httpGet.releaseConnection();
            return resultString;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    /**
     * post请求 参数可为null
     * @param url
     * @param param
     * @return
     */
    public static String doPost( String url, Map<String, String> param,String responseCharset,Map<String,String> headers) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建参数列表
            if (param != null) {
                List<NameValuePair> paramList = new ArrayList<NameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                // 模拟表单
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList,"utf-8");
                httpPost.setEntity(entity);
            }
            if(headers != null){
                for(Map.Entry<String,String> entry : headers.entrySet()){
                    //httpPost.setHeader("Content-Type","application/json;charset=utf-8");
                    httpPost.setHeader(entry.getKey(),entry.getValue());
                }
            }
            // 执行http请求
            response = closeableHttpClientClient.execute(httpPost);
            HttpEntity httpEntity =  response.getEntity();
            resultString = EntityUtils.toString(httpEntity, responseCharset);
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            httpPost.releaseConnection();


        } catch (Exception e) {
            e.printStackTrace();
        }

        return resultString;
    }

    /**
     * post请求,请求体为字符串
     * @param url
     * @param body
     * @return
     */
    public static String doPostString(String url, String body, Map<String, String> headers, String responseCharset) {
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            if(headers != null){
                for(Map.Entry<String,String> entry : headers.entrySet()){
                    //httpPost.setHeader("Content-Type","application/json;charset=utf-8");
                    httpPost.setHeader(entry.getKey(),entry.getValue());
                }
            }
            // 执行http请求
            httpPost.setEntity(new StringEntity(body,responseCharset));
            // 执行http请求
            response = closeableHttpClientClient.execute(httpPost);

    /*        StatusLine statusLine = response.getStatusLine();
            Header[] allHeaders = response.getAllHeaders();
            System.out.println("状态码："+statusLine.getStatusCode());
            for(Header header : allHeaders){
                System.out.println(header.getName()+"-->"+header.getValue());
            }
*/
            HttpEntity httpEntity =  response.getEntity();
            resultString = EntityUtils.toString(httpEntity, responseCharset);
            //释放输入流
            EntityUtils.consumeQuietly(httpEntity);
            //关闭response
            response.close();
            //释放连接
            httpPost.releaseConnection();

        } catch (Exception e) {
            e.printStackTrace();
        }


        return resultString;
    }

    /**
     * 获取下载的文件名
     * @param response
     * @return
     */
   public static String getFileName(HttpResponse response) {
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null) {
            HeaderElement[] values = contentHeader.getElements();
            if (values.length == 1) {
                NameValuePair param = values[0].getParameterByName("filename");
                if (param != null) {
                    try {
                        //filename = new String(param.getValue().toString().getBytes(), "utf-8");
                        //filename=URLDecoder.decode(param.getValue(),"utf-8");
                        filename = param.getValue();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return filename;
    }

    public  static void main(String[] args){
        String url ="http://www.aoshan-academy.com/asxypxserver/rest/pxxmsbTask/callBack";
        JSONArray jsonArray = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("companyCode", "33029102121");
            obj.put("isCorrect", 0);
            jsonArray.add(obj);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("callBackVoList", jsonArray);

        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");

        String s = HttpUtil.doPostString(url, JSON.toJSONString(jsonObject), headers, "utf-8");
        System.out.println(s);
    }

}
