package cn.smarthse.util.common.date;



import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by DengLibin on 2019/10/14.
 */
public class DateUtils {
    public static final  String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final  String DATE_PATTERN = "yyyy-MM-dd";

    private static String[] weekDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
    public static Date parseDate(String dateString,String pattern) throws ParseException {
        DateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(dateString);
        return date;
    }
    public static  String format(Date date,String pattern){
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }
    public static String getNowDate( String pattern){
        // 线程安全的格式化类，不用每次都new个SimpleDateFormat
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }
    public static String getNowDateString(){
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }
    /**
     * 字符串转日期
     * @param dateTime
     * @param pattern
     * @return
     */
    public static LocalDateTime parseDateTime(String dateTime,String pattern){
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(dateTime,dateTimeFormatter);
    }


    /**
     * 获取年份
     * @return
     */
    public static int getYear(){
        /*Year year = Year.now();
        return Integer.parseInt(year.toString());*/
        return LocalDate.now().getYear();
    }

    /**
     * 获取月份
     * @return
     */
    public static int getMonth(){
       /* Calendar calendar=Calendar.getInstance();
        int month=calendar.get(Calendar.MONTH)+1; //获得当前时间的月份，月份从0开始所以结果要加1
        return month;*/
        Month month = LocalDate.now().getMonth();
        return  month.getValue();

    }

    /**
     * 获取第几号
     * @return
     */
    public static int getDay(){
       /* Calendar calendar=Calendar.getInstance();
        //获得当前时间的月份，月份从0开始所以结果要加1
        int day=calendar.get(Calendar.DAY_OF_MONTH);
        return day;*/
        return  LocalDate.now().getDayOfMonth();
    }

    public static Date getDate(String dateStr,String pattern){
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 星期
     * @param localDate
     * @return
     */
    public static String getWeekOfDate(LocalDate localDate) {

        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        int w = dayOfWeek.getValue();
        if (w < 0 || w >=7)
            w = 0;
        return weekDays[w];
    }
    public static int getDayOfWeek(LocalDate localDate){
        return localDate.getDayOfWeek().getValue();
    }

    /**
     * 判断是否是闰年
     * @param year
     * @return
     */
    public static boolean isLeapYear(int year){
        Year y = Year.of(year);
        return y.isLeap();
    }

    /**
     * 根据年份数，该年的月份数,该月的天数 返回日期
     * @param year
     * @param month
     * @param days
     * @return
     */
    public static LocalDate getDate(int year,int month,int days){
        Year y = Year.of(year);
        YearMonth yearMonth = y.atMonth(month);
        return yearMonth.atDay(days);


    }

    /**
     * 如果某年是平年，但天数如果写的是29会自动转成28
     * @param year
     * @param month
     * @param days
     * @return
     */
    public static LocalDate getDateAutoParse(int year,int month,int days){
        MonthDay monthDay = MonthDay.of(month,days);
        return monthDay.atYear(year);
    }
    public static String getDateString(int year,int month,int day){
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        MonthDay monthDay = MonthDay.of(month,day);
        LocalDate date =  monthDay.atYear(year);
        return dateTimeFormatter.format(date);
    }
    public static String getDateTimeString(LocalDate localDate){
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return dateTimeFormatter.format(localDate);
    }

    /**
     * 当前日期的下几个日期
     * @param localDate
     * @return
     */
    public static  String getNextDate(LocalDate localDate,int i,String pattern){
        LocalDate  nextDate = localDate.plusDays(i);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(nextDate);

    }

    /**
     * 当前日期的下几个日期
     * @param localDate
     * @param i
     * @return
     */
    public static  LocalDate getNextDate(LocalDate localDate,int i){
        return localDate.plusDays(i);
    }

    /**
     * 当前时间
     * @return
     */
    public static String getNowTime() {
        String dateTime = getNowDateString();
        return dateTime.substring(11);
    }

    /**
     * 计算两个日期之间相差多少个小时
     * @param time1
     * @param time2
     * @return
     */
    public static long calculateHours(LocalDateTime time1, LocalDateTime time2) {

        return ChronoUnit.HOURS.between(time1, time2);
    }

    /**
     * 获取本周的第一天的日期
     * @return
     */
    public static LocalDate getStartDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        Date date = cal.getTime();
        return  getFromDate(date).toLocalDate();
    }
    /**
     * 获取本周的最后一天的日期
     * @return
     */
    public static LocalDate getEndDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.SATURDAY); //周六为一周的结束
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        Date date = cal.getTime();
        return  getFromDate(date).toLocalDate().plusDays(1);//加一天 到周日
    }

    /**
     * 判断两个date类型的 年月日，是否相等
     * @return true-日期相等
     */
    public static boolean judgeEqualBetweenDate(Date d1, Date d2){

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString1 = sdf.format(d1);
        String dateString2 = sdf.format(d2);

        return dateString1.equals(dateString2);
    }

    public static LocalDate getStartDateOfMonth() {
        LocalDate now = LocalDate.now();
        return getLocalDateTime(now.getYear(), now.getMonthValue(), 1,0,0,0).toLocalDate();
    }

    public static LocalDate getEndDateOfMonth() {
        LocalDate now = LocalDate.now();
        return getLocalDateTime(now.getYear(), now.getMonthValue(), now.getMonth().maxLength(),0,0,0).toLocalDate();
    }

    /**
     * 今天的日期
     * @param pattern
     * @return
     */
    public String getDateToDay(String pattern){
        LocalDate today = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(today);
    }

    /**
     * 计算两个日期之间天数
     * @param date1
     * @param date2
     * @return
     */
    public static long calculateDays(LocalDate date1,LocalDate date2){

        return ChronoUnit.DAYS.between(date1,date2);
    }

    /**
     * 计算两个日期间的年数
     * @param date1
     * @param date2
     * @return
     */
    public static long calculateYears(LocalDate date1,LocalDate date2){

        return ChronoUnit.YEARS.between(date1,date2);
    }
    /**
     * 计算两个日期间的月份数
     * @param date1
     * @param date2
     * @return
     */
    public static long calculateMonths(LocalDate date1,LocalDate date2){

        return ChronoUnit.MONTHS.between(date1,date2);
    }

    /**
     * 计算两个日期之间的分钟数
     * @param time1
     * @param time2
     * @return
     */
    public static long calculateMinutes(LocalDateTime time1,LocalDateTime time2){
        return ChronoUnit.MINUTES.between(time1,time2);
    }

    /**
     * 计算两个日期之间的秒钟数
     * @param time1
     * @param time2
     * @return
     */
    public static long calculateSeconds(LocalDateTime time1,LocalDateTime time2){
        return ChronoUnit.SECONDS.between(time1,time2);
    }

    /**
     * 获取毫秒数
     * @param localDateTime
     * @return
     */
    public static  long getMill(LocalDateTime localDateTime){
        return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    /**
     * Date和LocalDateTime互转
     * @param date
     * @return
     */
    public static LocalDateTime getFromDate(Date date){
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return  LocalDateTime.ofInstant(instant,zoneId);
    }
    public static Date getDate(LocalDateTime localDateTime){
        if (localDateTime == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.of("GMT+08");
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }
    public static String formatDate(LocalDateTime time){
        return formatDate(time,"yyyy-MM-dd HH:mm:ss");
    }
    public static String formatDate(LocalDateTime time,String pattern){
        if (time == null) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(time);
    }
    public static String formatDate(LocalDate date,String pattern){
        if (date == null) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(date);
    }
    public static Date getDateNow(){
        ZoneId zoneId = ZoneId.of("GMT+08");
        LocalDateTime localDateTime = LocalDateTime.now();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);

        Date date = Date.from(zdt.toInstant());
        return date;
    }



    /**
     * 设置指定日期时间
     * @param year
     * @param month
     * @param day
     * @param hour
     * @param min
     * @param second
     * @return
     */
    public static LocalDateTime getLocalDateTime(int year,int month,int day,int hour,int min,int second){
        return LocalDateTime.of(year, month, day, hour, min, second);
    }


    //yyyy-MM-dd
    public static LocalDate getLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static int getHour() {
        return LocalDateTime.now().getHour();
    }

    //通过毫秒数返回日期时间
    public static String getDateTimeStringByMil(long millisecond ) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_PATTERN);
        return format.format(date);
    }
    //通过毫秒数返回日期
    public static String getDateStringByMil(long millisecond ) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        return format.format(date);
    }

    public static long getMillisecond(){
        return new Date().getTime();
    }

    //获取毫秒数
    public static long getMillisecondByDateTimeString(String dateTime, String pattern)  {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return  format.parse(dateTime).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
            return  0L;
        }
    }

    /**
     * 计算两个日期之间相差的日期数
     * @param fromDate
     * @param toDate
     * @return
     */
    public static DayCompare dayComparePrecise(LocalDate fromDate, LocalDate toDate){
        boolean isChange = false;
        if(toDate.compareTo(fromDate)<0){
            LocalDate temp =  fromDate;
            fromDate = toDate;
            toDate = temp;
            isChange = true;
        }
        int fromYear = fromDate.getYear();
        int fromMonth = fromDate.getMonthValue();
        int fromDay = fromDate.getDayOfMonth();

        int toYear = toDate.getYear();
        int toMonth = toDate.getMonthValue();
        int toDay = toDate.getDayOfMonth();
        int year = toYear  -  fromYear;
        int month = toMonth  - fromMonth;
        if(month < 0){
            year -=1;
            month = (12-fromMonth)+toMonth;
        }

        int day = toDay  - fromDay;
        if(day < 0){
            month -= 1;
            int maxDay = getMaxDaysOfOneMonth(fromYear,fromMonth);
            day =  maxDay- fromDay+ toDay;
        }
        if(month < 0){
            year -=1;
            month = (12+month);
        }

        if(isChange ){
            year = 0 - year;
            month = 0 - month;
            day = 0 - day;
        }
        return new DayCompare(year, month, day);
    }

    private static int getMaxDaysOfOneMonth(int year,int month)
    {
        int day = 1;
        Calendar cal = Calendar.getInstance();
        cal.set(year,month - 1,day);
        return cal.getActualMaximum(Calendar.DATE);
    }



    public  static class DayCompare{
        private int year;
        private int month;
        private int day;

        public DayCompare(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDay() {
            return day;
        }

        public void setDay(int day) {
            this.day = day;
        }
    }



    //计算某月共多少天
    public static int getMonthDays(int year, int month){
        if(month == 2){ //2月
            if(isLeap(year))
            {
                return 29;
            }else
            {
                return 28;
            }
        }
        //每月30天的月份
        else if(month == 4 || month == 6 || month == 9 ||month == 11)
        {
            return 30;
        }
        //每月31天的月份
        else
        {
            return 31;
        }
    }
    //是否是闰年
    public static  boolean isLeap(int year){
        if((year % 4 == 0 && year % 100 != 0) || (year % 400 == 0))
        {
            return true;
        }
        return false;
    }
}
