package cn.smarthse.util.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.serializer.ToStringSerializer;

import java.util.Date;

/**
 * @author 邓力宾
 * @date 2020-08-06 14:44
 * @desc
 */
public class JsonUtils {
    private JsonUtils(){}

    public static  String toJsonString(Object javaBean){
        /**
         QuoteFieldNames———-输出key时是否使用双引号,默认为true
         WriteMapNullValue——–是否输出值为null的字段,默认为false
         WriteNullNumberAsZero—-数值字段如果为null,输出为0,而非null
         WriteNullListAsEmpty—–List字段如果为null,输出为[],而非null
         WriteNullStringAsEmpty—字符类型字段如果为null,输出为”“,而非null
         WriteNullBooleanAsFalse–Boolean字段如果为null,输出为false,而非null
         DisableCircularReferenceDetect FastJson提供了SerializerFeature.DisableCircularReferenceDetect这个序列化选项，用来关闭引用检测。
         * 关闭引用检测后，重复引用对象时就不会被$ref代替，但是在循环引用时也会导致StackOverflowError异常
         */
        // Long 转String
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class , ToStringSerializer.instance);
        return JSON.toJSONString(javaBean, serializeConfig,
                SerializerFeature.PrettyFormat,
                SerializerFeature.WriteMapNullValue,
                SerializerFeature.DisableCircularReferenceDetect,
                SerializerFeature.WriteDateUseDateFormat); // 使用默认的日期格式 JSON.DEFFAULT_DATE_FORMAT yyyy-MM-dd HH:mm:ss
    }

    /**
     * 转json字符串
     * @param javaBean
     * @return
     */
    public static  String toJsonStringNoPretty(Object javaBean){
        /**
         QuoteFieldNames———-输出key时是否使用双引号,默认为true
         WriteMapNullValue——–是否输出值为null的字段,默认为false
         WriteNullNumberAsZero—-数值字段如果为null,输出为0,而非null
         WriteNullListAsEmpty—–List字段如果为null,输出为[],而非null
         WriteNullStringAsEmpty—字符类型字段如果为null,输出为”“,而非null
         WriteNullBooleanAsFalse–Boolean字段如果为null,输出为false,而非null
         DisableCircularReferenceDetect FastJson提供了SerializerFeature.DisableCircularReferenceDetect这个序列化选项，用来关闭引用检测。
         * 关闭引用检测后，重复引用对象时就不会被$ref代替，但是在循环引用时也会导致StackOverflowError异常
         */
        // Long 转String
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class , ToStringSerializer.instance);
        return JSON.toJSONString(javaBean, serializeConfig,
                SerializerFeature.PrettyFormat,
                SerializerFeature.WriteMapNullValue,
                SerializerFeature.DisableCircularReferenceDetect,
                SerializerFeature.WriteDateUseDateFormat); // 使用默认的日期格式 JSON.DEFFAULT_DATE_FORMAT yyyy-MM-dd HH:mm:ss
    }
}
