/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.redis.handler;

import cn.hutool.core.util.StrUtil;
import org.redisson.api.NameMapper;

public class KeyPrefixHandler
implements NameMapper {
    private final String keyPrefix;

    public KeyPrefixHandler(String keyPrefix) {
        this.keyPrefix = StrUtil.isBlank((CharSequence)keyPrefix) ? "" : keyPrefix + ":";
    }

    public String map(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        if (StrUtil.isNotBlank((CharSequence)this.keyPrefix) && !name.startsWith(this.keyPrefix)) {
            return this.keyPrefix + name;
        }
        return name;
    }

    public String unmap(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        if (StrUtil.isNotBlank((CharSequence)this.keyPrefix) && name.startsWith(this.keyPrefix)) {
            return name.substring(this.keyPrefix.length());
        }
        return name;
    }
}

