/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.json.utils;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = (ObjectMapper)SpringUtil.getBean(ObjectMapper.class);

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull((Object)object)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Dict parseMap(String text) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return (Dict)OBJECT_MAPPER.readValue(text, OBJECT_MAPPER.getTypeFactory().constructType(Dict.class));
        }
        catch (MismatchedInputException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Dict> parseArrayMap(String text) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return (List)OBJECT_MAPPER.readValue(text, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, Dict.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)text)) {
            return new ArrayList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(text, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonUtils() {
    }
}

