/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.encrypt.filter;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.encrypt.domain.EncryptParam;
import cn.smarthse.common.encrypt.utils.EncryptUtils;
import cn.smarthse.common.json.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DecryptRequestBodyWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public DecryptRequestBodyWrapper(HttpServletRequest request, String privateKey, String headerFlag) throws IOException {
        super(request);
        String encryptPassword = request.getHeader(headerFlag);
        String decryptSm4 = EncryptUtils.decryptBySm2(encryptPassword, privateKey);
        String sm4Password = EncryptUtils.decryptByBase64(decryptSm4);
        request.setCharacterEncoding("UTF-8");
        byte[] readBytes = IoUtil.readBytes((InputStream)request.getInputStream(), (boolean)false);
        String requestBody = new String(readBytes, StandardCharsets.UTF_8);
        EncryptParam encryptParam = (EncryptParam)JsonUtils.parseObject((String)requestBody, EncryptParam.class);
        if (encryptParam == null || StrUtil.isBlank((CharSequence)encryptParam.getData())) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        String decryptBody = EncryptUtils.decryptBySm4(encryptParam.getData(), sm4Password);
        this.body = decryptBody.getBytes(StandardCharsets.UTF_8);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public int getContentLength() {
        return this.body.length;
    }

    public long getContentLengthLong() {
        return this.body.length;
    }

    public String getContentType() {
        return "application/json";
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return bais.read();
            }

            public int available() {
                return DecryptRequestBodyWrapper.this.body.length;
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

