/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.encrypt.annotation.EncryptField;
import cn.smarthse.common.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.common.encrypt.core.EncryptContext;
import cn.smarthse.common.encrypt.core.EncryptorManager;
import cn.smarthse.common.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.common.encrypt.enumd.EncodeType;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class MybatisEncryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final EncryptorProperties defaultProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        return invocation;
    }

    public Object plugin(Object target) {
        ParameterHandler parameterHandler;
        Object parameterObject;
        if (target instanceof ParameterHandler && ObjectUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            this.encryptHandler(parameterObject);
        }
        return target;
    }

    private void encryptHandler(Object sourceObject) {
        if (ObjectUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::encryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtil.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::encryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtil.isNull(fields)) {
            return;
        }
        try {
            for (Field field : fields) {
                field.set(sourceObject, this.encryptField(Convert.toStr((Object)field.get(sourceObject)), field));
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private String encryptField(String value, Field field) {
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setEncode(EncodeType.BASE64);
        encryptContext.setPassword(this.defaultProperties.getPassword());
        encryptContext.setPrivateKey(this.defaultProperties.getPrivateKey());
        encryptContext.setPublicKey(this.defaultProperties.getPublicKey());
        encryptContext.setDataProcessingMethodsType(ObjectUtil.isNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? DataProcessingMethodsType.VAGUE : encryptField.dataProcessingMethodsType());
        return this.encryptorManager.encrypt(value, encryptContext);
    }

    public void setProperties(Properties properties) {
    }

    public MybatisEncryptInterceptor(EncryptorManager encryptorManager, EncryptorProperties defaultProperties) {
        this.encryptorManager = encryptorManager;
        this.defaultProperties = defaultProperties;
    }
}

