/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.encrypt.filter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.smarthse.common.core.exception.ServiceException;
import cn.smarthse.common.encrypt.annotation.ApiEncrypt;
import cn.smarthse.common.encrypt.config.properties.ApiDecryptProperties;
import cn.smarthse.common.encrypt.domain.EncryptVo;
import cn.smarthse.common.encrypt.filter.DecryptRequestBodyWrapper;
import cn.smarthse.common.encrypt.filter.EncryptResponseBodyWrapper;
import cn.smarthse.common.json.utils.JsonUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CryptoFilter
implements Filter {
    private final ApiDecryptProperties properties;

    public CryptoFilter(ApiDecryptProperties properties) {
        this.properties = properties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        ApiEncrypt apiEncrypt = this.getApiEncryptAnnotation(servletRequest);
        boolean requestFlag = apiEncrypt != null && apiEncrypt.request();
        boolean responseFlag = apiEncrypt != null && apiEncrypt.response();
        Object requestWrapper = null;
        EncryptResponseBodyWrapper responseWrapper = null;
        EncryptResponseBodyWrapper responseBodyWrapper = null;
        if (HttpMethod.PUT.matches(servletRequest.getMethod()) || HttpMethod.POST.matches(servletRequest.getMethod())) {
            if (requestFlag) {
                String headerValue = servletRequest.getHeader(this.properties.getHeaderFlag());
                if (StrUtil.isNotBlank((CharSequence)headerValue)) {
                    requestWrapper = new DecryptRequestBodyWrapper(servletRequest, this.properties.getPrivateKey(), this.properties.getHeaderFlag());
                } else if (ObjectUtil.isNotNull((Object)apiEncrypt)) {
                    HandlerExceptionResolver exceptionResolver = (HandlerExceptionResolver)SpringUtil.getBean((String)"handlerExceptionResolver", HandlerExceptionResolver.class);
                    exceptionResolver.resolveException(servletRequest, servletResponse, null, (Exception)new ServiceException("\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743"));
                    return;
                }
            } else {
                requestWrapper = servletRequest;
            }
        }
        if (responseFlag) {
            responseWrapper = responseBodyWrapper = new EncryptResponseBodyWrapper(servletResponse);
        }
        chain.doFilter((ServletRequest)ObjectUtil.defaultIfNull((Object)requestWrapper, (Object)request), (ServletResponse)ObjectUtil.defaultIfNull((Object)((Object)responseWrapper), (Object)response));
        if (responseFlag) {
            servletResponse.reset();
            servletResponse.setContentType("application/json;charset=UTF-8");
            String encryptContent = responseBodyWrapper.getEncryptContent(servletResponse, this.properties.getPublicKey(), this.properties.getHeaderFlag());
            EncryptVo encryptVo = new EncryptVo();
            encryptVo.setCode(HttpStatus.OK);
            encryptVo.setResult(encryptContent);
            servletResponse.getWriter().write(Objects.requireNonNull(JsonUtils.toJsonString((Object)encryptVo)));
        }
    }

    private ApiEncrypt getApiEncryptAnnotation(HttpServletRequest servletRequest) {
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)SpringUtil.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        try {
            Object handler;
            HandlerExecutionChain mappingHandler = handlerMapping.getHandler(servletRequest);
            if (ObjectUtil.isNotNull((Object)mappingHandler) && ObjectUtil.isNotNull((Object)(handler = mappingHandler.getHandler())) && handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                return (ApiEncrypt)handlerMethod.getMethodAnnotation(ApiEncrypt.class);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public void destroy() {
    }
}

