/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.encrypt.config;

import cn.smarthse.common.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.common.encrypt.core.EncryptorManager;
import cn.smarthse.common.encrypt.interceptor.MybatisDecryptInterceptor;
import cn.smarthse.common.encrypt.interceptor.MybatisEncryptInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EncryptorProperties.class})
@ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
public class EncryptorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EncryptorAutoConfiguration.class);
    @Autowired
    private EncryptorProperties properties;

    @Bean
    public EncryptorManager encryptorManager() {
        return new EncryptorManager(this.properties.getTypeAliasesPackage());
    }

    @Bean
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        return new MybatisEncryptInterceptor(encryptorManager, this.properties);
    }

    @Bean
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        return new MybatisDecryptInterceptor(encryptorManager, this.properties);
    }
}

