/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.encrypt.config;

import cn.smarthse.common.encrypt.config.properties.ApiDecryptProperties;
import cn.smarthse.common.encrypt.filter.CryptoFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={ApiDecryptProperties.class})
@ConditionalOnProperty(value={"api-decrypt.enabled"}, havingValue="true")
public class ApiDecryptAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApiDecryptAutoConfiguration.class);

    @Bean
    public FilterRegistrationBean<CryptoFilter> cryptoFilterRegistration(ApiDecryptProperties properties) {
        log.info("\u521d\u59cb\u5316 CryptoFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new CryptoFilter(properties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("cryptoFilter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }
}

