/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.db.common.service.imp;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Resource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BaseServiceImp<M extends BaseMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements IBaseService<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    @Autowired(required=false)
    protected M dao;
    private static final String VALID_COLUMN = "is_valid";
    private static final int IN_SIZE = 200;
    private static final int BATCH_SIZE = 1000;

    @Override
    public LambdaQueryWrapper<T> queryWrapperIn(LambdaQueryWrapper<T> lambdaQueryWrapper, SFunction<T, ?> f, List<?> params) {
        if (params.size() < 200) {
            return (LambdaQueryWrapper)lambdaQueryWrapper.in(f, params);
        }
        List listList = ListUtils.split(params, (int)200);
        lambdaQueryWrapper.and(w -> {
            for (int i = 0; i < listList.size(); ++i) {
                if (i < listList.size() - 1) {
                    ((LambdaQueryWrapper)w.in((Object)f, (Collection)listList.get(i))).or();
                    continue;
                }
                w.in((Object)f, (Collection)listList.get(i));
            }
        });
        return lambdaQueryWrapper;
    }

    @Override
    public QueryWrapper<T> queryWrapperIn(QueryWrapper<T> queryWrapper, String column, List<?> params) {
        if (params.size() < 200) {
            return (QueryWrapper)queryWrapper.in((Object)column, params);
        }
        List listList = ListUtils.split(params, (int)200);
        queryWrapper.and(w -> {
            for (int i = 0; i < listList.size(); ++i) {
                if (i < listList.size() - 1) {
                    ((QueryWrapper)w.in((Object)column, (Collection)listList.get(i))).or();
                    continue;
                }
                w.in((Object)column, (Collection)listList.get(i));
            }
        });
        return queryWrapper;
    }

    @Override
    public void logicDel(Number id) {
        UpdateWrapper wrapper = Wrappers.update();
        ((UpdateWrapper)wrapper.eq((Object)"id", (Object)id)).set((Object)VALID_COLUMN, (Object)false);
        this.update((Wrapper)wrapper);
    }

    @Override
    public T get(Number id) {
        if (id == null) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)id);
        wrapper.eq((Object)VALID_COLUMN, (Object)true);
        return (T)((BaseEntity)this.getOne((Wrapper)wrapper));
    }

    @Override
    public List<T> getByIds(Collection<? extends Number> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        queryWrapper.eq((Object)VALID_COLUMN, (Object)true);
        queryWrapper.orderByAsc((Object)"id");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public IPage<T> getPage(int pageNum, int pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)VALID_COLUMN, (Object)true);
        queryWrapper.orderByAsc((Object)"id");
        return this.page((IPage)new Page((long)pageNum, (long)pageSize), (Wrapper)queryWrapper);
    }

    @Override
    public List<T> getAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)VALID_COLUMN, (Object)true);
        queryWrapper.orderByAsc((Object)"id");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public T add(T t) {
        this.baseMapper.insert(t);
        return t;
    }

    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }
}

