/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.ai.service.impl;

import cn.smarthse.ai.dao.QaRecordMapper;
import cn.smarthse.modules.common.IBailianAiAgentService;
import cn.smarthse.modules.common.IQaRecordService;
import cn.smarthse.modules.common.model.QaRecord;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class QaRecordServiceImpl
extends ServiceImpl<QaRecordMapper, QaRecord>
implements IQaRecordService {
    @Autowired
    IBailianAiAgentService bailianAiAgentService;

    public QaRecord getByBusinessId(String businessId, String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaRecord::getBusinessId, (Object)businessId);
        queryWrapper.eq(QaRecord::getType, (Object)type);
        return (QaRecord)((QaRecordMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    public List<QaRecord> listByType(List<Long> cids, String type, List<String> existList) {
        if (CollectionUtils.isEmpty(cids) || StringUtils.isBlank((CharSequence)type)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(QaRecord::getType, (Object)type)).eq(QaRecord::getIsValid, (Object)true);
        if (CollectionUtils.isNotEmpty(cids)) {
            queryWrapper.in(QaRecord::getCid, cids);
        }
        if (CollectionUtils.isNotEmpty(existList)) {
            queryWrapper.notIn(QaRecord::getBusinessId, existList);
        }
        return ((QaRecordMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Transactional
    public List<QaRecord> insertList(List<QaRecord> record) {
        if (CollectionUtils.isEmpty(record)) {
            return Collections.emptyList();
        }
        record.forEach(item -> {
            item.setCreateTime(LocalDateTime.now());
            item.setUpdateTime(LocalDateTime.now());
        });
        this.saveBatch(record);
        return record;
    }

    @Transactional
    public void updateAnswerQaRecord(List<Long> cidList) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(QaRecord::getType, (Object)"09")).and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(QaRecord::getAnswerContent)).or()).eq(QaRecord::getAnswerContent, (Object)"")).or()).likeLeft(QaRecord::getAnswerContent, (Object)"\u751f\u6210ai\u667a\u80fd\u95ee\u7b54\u5f02\u5e38"))).eq(QaRecord::getIsValid, (Object)true);
        if (CollectionUtils.isNotEmpty(cidList)) {
            queryWrapper.in(QaRecord::getCid, cidList);
        }
        queryWrapper.orderByAsc(QaRecord::getUpdateTime);
        queryWrapper.last("limit 100");
        List qaRecordList = ((QaRecordMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Map<String, String> checkIdAndQuestion = qaRecordList.stream().filter(Objects::nonNull).collect(Collectors.toMap(QaRecord::getBusinessId, QaRecord::getQuestionContent));
        Map checkIdAndAnswer = this.bailianAiAgentService.callWorkFlowByJCCB(checkIdAndQuestion);
        qaRecordList.forEach(qaRecord -> {
            qaRecord.setAnswerContent((String)checkIdAndAnswer.get(qaRecord.getBusinessId()));
            qaRecord.setUpdateTime(LocalDateTime.now());
        });
        this.saveOrUpdateBatch(qaRecordList);
    }
}

