/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.ai.service.impl;

import cn.smarthse.modules.common.IBailianAiAgentService;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgent;
import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgentOptions;
import com.alibaba.dashscope.app.Application;
import com.alibaba.dashscope.app.ApplicationParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.xxl.job.core.context.XxlJobHelper;
import io.reactivex.Flowable;
import jakarta.annotation.Resource;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@DubboService
public class IBailianAiAgentServiceImpl
implements IBailianAiAgentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IBailianAiAgentServiceImpl.class);
    @Value(value="${bailian.dashscope.agent.app-id.jccb}")
    String appId;
    @Value(value="${bailian.dashscope.agent.api-key}")
    String apiKey;
    @Autowired
    private DashScopeAgent dashScopeAgent;
    @Resource(name="baiLianAiThreadPoolExecutor")
    private ExecutorService executor;

    public String callWorkFlow(String message, String appId) {
        Prompt prompt = new Prompt(message, (ChatOptions)DashScopeAgentOptions.builder().withAppId(appId).build());
        ChatResponse response = this.dashScopeAgent.call(prompt);
        return response.getResult().getOutput().getText();
    }

    public String callWorkFlowStream(String message, String appId) throws NoApiKeyException, InputRequiredException, InterruptedException {
        ApplicationParam param = ((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().apiKey(this.apiKey)).appId(appId).prompt(message).incrementalOutput(Boolean.valueOf(true)).build();
        Application application = new Application();
        Flowable result = application.streamCall(param);
        StringBuffer stringBuffer = new StringBuffer("");
        result.blockingForEach(data -> {
            String text = data.getOutput().getText();
            if (StringUtils.isNotEmpty((String)text) && !"null".equals(text)) {
                stringBuffer.append(text);
            }
        });
        return stringBuffer.toString();
    }

    public Map<String, String> callWorkFlowByJCCB(Map<String, String> checkIdAndQuestion) {
        if (CollectionUtils.isEmpty(checkIdAndQuestion)) {
            return Collections.emptyMap();
        }
        XxlJobHelper.log((String)("\u9700\u8981\u751f\u6210\u7684\u6570\u91cf:" + checkIdAndQuestion.size()), (Object[])new Object[0]);
        HashMap<String, String> checkIdAndAnswer = new HashMap<String, String>();
        checkIdAndQuestion.forEach((checkId, question) -> {
            Object result;
            long l = System.currentTimeMillis();
            try {
                result = IBailianAiAgentServiceImpl.extractAndCleanText(this.callWorkFlowStream((String)question, this.appId));
                XxlJobHelper.log((String)("\u68c0\u6d4b\u8d85\u6807ai\u95ee\u7b54\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) / 1000L + "\u79d2"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                result = "\u751f\u6210ai\u667a\u80fd\u95ee\u7b54\u5f02\u5e38" + e.getMessage();
                XxlJobHelper.log((String)("\u751f\u6210ai\u667a\u80fd\u95ee\u7b54\u5f02\u5e38:" + e.getMessage() + "\u68c0\u6d4b\u8d85\u6807ai\u95ee\u7b54\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) / 1000L + "\u79d2"), (Object[])new Object[0]);
            }
            checkIdAndAnswer.put((String)checkId, (String)result);
        });
        return checkIdAndAnswer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> callWorkFlowByJCCB2(Map<String, String> checkIdAndQuestion) {
        if (CollectionUtils.isEmpty(checkIdAndQuestion)) {
            return Collections.emptyMap();
        }
        long timeMillis = System.currentTimeMillis();
        Map<Object, Object> checkIdAndAnswer = new HashMap();
        try {
            List<CompletableFuture> futures = checkIdAndQuestion.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> {
                Object result;
                String checkId = (String)entry.getKey();
                String message = (String)entry.getValue();
                try {
                    result = IBailianAiAgentServiceImpl.extractAndCleanText(this.callWorkFlowStream(message, this.appId));
                }
                catch (InputRequiredException | NoApiKeyException e) {
                    result = "\u751f\u6210ai\u667a\u80fd\u95ee\u7b54\u5f02\u5e38";
                }
                catch (Exception e) {
                    result = "\u5904\u7406\u8fc7\u7a0b\u53d1\u751f\u672a\u77e5\u5f02\u5e38: " + e.getMessage();
                }
                return new AbstractMap.SimpleEntry<String, Object>(checkId, result);
            }, this.executor)).toList();
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            try {
                allFutures.get(120L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                futures.forEach(future -> future.cancel(true));
                throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff0c\u5df2\u53d6\u6d88\u672a\u5b8c\u6210\u4efb\u52a1", e);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
            }
            Map<Object, Object> map = checkIdAndAnswer = futures.stream().map(CompletableFuture::join).filter(item -> item != null && StringUtils.isNotBlank((CharSequence)((CharSequence)item.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing));
            return map;
        }
        finally {
            this.executor.shutdown();
            log.error("\u68c0\u6d4b\u8d85\u6807ai\u95ee\u7b54\u8017\u65f6\uff1a" + (System.currentTimeMillis() - timeMillis) / 1000L + "\u79d2\uff0c\u5904\u7406\u6570\u91cf\uff1a" + checkIdAndQuestion.size() + "\u8fd4\u56de\u5904\u7406\u7ed3\u679c\u6570\u91cf\uff1a" + checkIdAndAnswer.size());
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String extractAndCleanText(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String startKeyword = "A\u3001\u5de5\u7a0b\u63a7\u5236\u63aa\u65bd\u5efa\u8bae";
        int startIndex = text.indexOf(startKeyword);
        if (startIndex == -1) {
            return text;
        }
        String extractedText = text.substring(startIndex).replaceAll("\\*\\*", "");
        Pattern pattern = Pattern.compile("<ref[^>]*>.*?</ref>", 32);
        Matcher matcher = pattern.matcher(extractedText);
        return matcher.replaceAll("");
    }
}

