/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.service.common.util;

import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.util.StopWatch;

public abstract class ODDGenerator {
    private static final FastDateFormat pattern = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
    private static final AtomicInteger atomicInteger = new AtomicInteger(1);
    private static ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();

    public static String getLongOrderNum(String lock) {
        if (Objects.isNull(threadLocal.get())) {
            lock = Objects.isNull(lock) ? UUID.randomUUID().toString() : lock;
            StringBuilder builder = new StringBuilder(pattern.format(Instant.now().toEpochMilli()));
            builder.append(Math.abs(lock.hashCode()));
            builder.append(atomicInteger.getAndIncrement());
            threadLocal.set(builder);
        }
        return threadLocal.get().toString();
    }

    public static String getShortOrderNum(String lock) {
        if (Objects.isNull(threadLocal.get())) {
            lock = Objects.isNull(lock) ? UUID.randomUUID().toString() : lock;
            StringBuilder builder = new StringBuilder(ThreadLocalRandom.current().nextInt(0, 999));
            builder.append(Math.abs(lock.hashCode()));
            builder.append(atomicInteger.getAndIncrement());
            threadLocal.set(builder);
        }
        return threadLocal.get().toString();
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        HashSet<String> set = new HashSet<String>();
        FutureTask<String> task = null;
        StopWatch watchTime = new StopWatch();
        watchTime.start();
        for (int i = 0; i < 1000; ++i) {
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ODDGenerator.getShortOrderNum(null);
                }
            };
            task = new FutureTask<String>(callable);
            new Thread(task).start();
            set.add(task.get());
            System.out.println(task.get());
        }
        watchTime.stop();
        System.out.println(watchTime.getTotalTimeMillis());
        System.out.println(set.size());
    }
}

