package cn.smarthse.serve.service.common.util;

import cn.smarthse.serve.common.web.exception.SmarthseServiceException;

/**
 * @ClassName VideoUtils
 * @Description 视频工具类
 * @Author ChenLiang
 * @ModifyDate 2022/3/30 16:37
 */

public class VideoUtils {
    /**
     * 比较时长，
     *
     * @param d1 例如 10:20:50
     * @param d2 例如 10:20:50
     * @return d1 >= d2
     */
    public static boolean compareDuration(String d1, String d2) {
        return duration2Second(d1) >= duration2Second(d2);
    }

    /**
     * 时长转秒
     * @param d 例如 10:20:50
     * @return
     */
    public static Long duration2Second(String d){
        String[] split = d.split(":");
        if(split.length > 3){
            throw new SmarthseServiceException("时长异常");
        }
        Long second = 0l;
        Long base = 1l;

        for (int i = split.length - 1; i >= 0; i--) {
            second += Long.parseLong(split[i])*base;
            base = base * 60;
        }
        return second;
    }
}
