package cn.smarthse.serve.service.common.util;

import cn.smarthse.serve.common.web.model.PageInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;

/**
 * @author 邓力宾
 * @date 2021/3/23 10:56
 * @desc
 */
public class PageUtils {
    private PageUtils(){}

    /**
     * 构造分页对象
     * @param page
     * @param <T>
     * @return
     */
    public static<T> PageInfo<T> newPageInfo(IPage<T> page){
        PageInfo<T> pageInfo = new PageInfo<>(page.getRecords());
        pageInfo.setTotal(page.getTotal());
        pageInfo.setPageNum((int)page.getCurrent());
        pageInfo.setPageSize((int)page.getSize());
        pageInfo.setList(page.getRecords());
        return pageInfo;
    }
     /**
     * 构造分页对象
     * @param pageInfo
     * @param <T>
     * @return
     */
    public static<T> PageInfo<T> newPageInfo(com.github.pagehelper.PageInfo<T> pageInfo){
        PageInfo<T> rPageInfo = new PageInfo<>(pageInfo.getList());
        rPageInfo.setTotal(pageInfo.getTotal());
        rPageInfo.setPageNum(pageInfo.getPageNum());
        rPageInfo.setPageSize(pageInfo.getPageSize());
        rPageInfo.setList(pageInfo.getList());
        return rPageInfo;
    }

}
