package cn.smarthse.serve.service.common;

import cn.smarthse.serve.common.util.SnowFlake;
import cn.smarthse.serve.service.common.component.PlatformIdGenerator;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;

/**
 * @author 邓力宾
 * @date 2021/4/13 14:30
 * @desc
 */
@SpringBootConfiguration
@Slf4j
public class PlatformDbAutoConfiguration {


    @Bean
    public PlatformIdGenerator platformIdGenerator(SnowFlake snowFlake){
        log.info("创建自定义id生成器:PlatformIdGenerator");
        return new PlatformIdGenerator(snowFlake);
    }
    /**
     * 创建该bean 启用分页功能
     * @return
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        log.info("创建分页拦截器:PaginationInterceptor");
        return new PaginationInterceptor();
    }
}
