package cn.smarthse.serve.service.common;

import cn.smarthse.serve.entity.base.BaseEntity;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Collection;
import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 自定义 公共 接口
 * @since 2020/3/17 0017 13:12
 */
public interface IBaseService<T> extends IService<T> {

    /**
     * 逻辑删除
     * @param id
     */
    void logicDel(Number id);

    /**
     * 逻辑删除 多个
     * @param ids
     */
    void logicDelMulti(List<Long> ids);
    /**
     * 根据id查询
     * @param id
     * @return
     */
    T get(Number id);

    /**
     * 根据多个id查询
     * @param ids
     * @return
     */
    List<T> getByIds(Collection<? extends Number> ids);


    /**
     * 简单分页查询
     * @param pageNum
     * @param pageSize
     * @return
     */
    IPage<T> getPage(int pageNum, int pageSize);

    /**
     * 查询所有按id排序
     * @return
     */
    List<T> getAll();

    /**
     * 添加
     * @param t
     * @return
     */
    T add(T t);


}
