package cn.smarthse.serve.service.common;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


/**
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 自定义公共逻辑实现
 * @since 2020/3/17 0017 13:14
 */
public   class BaseServiceImp<M extends BaseMapper<T>, T >
        extends ServiceImpl<M, T> implements IBaseService<T> {

    protected Logger logger = LoggerFactory.getLogger(getClass());
    protected static final  String VALID_COLUMN = "is_valid";

    @Override
    public void logicDel(Number id) {
        if(id == null){
            return;
        }
        UpdateWrapper<T> wrapper = Wrappers.update();
        wrapper.eq("id", id).set(VALID_COLUMN, false);
        this.update(wrapper);
    }

    @Override
    public void logicDelMulti(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return;
        }
        UpdateWrapper<T> wrapper = Wrappers.update();
        wrapper.in("id", ids.toArray(new Long[0])).set(VALID_COLUMN, false);
        this.update(wrapper);
    }

    /**
     * 根据id查询
     * @param id id
     * @return 对象
     */
    @Override
    public T get(Number id) {
        if(id == null){
            return null;
        }
        QueryWrapper<T> wrapper = new QueryWrapper<>();
        wrapper.eq("id", id);
        wrapper.eq(VALID_COLUMN, true);
        return this.getOne(wrapper);

    }

    /**
     * 根据多个id查询
     * @param ids
     * @return
     */
    @Override
    public List<T> getByIds(Collection<? extends Number> ids) {
        if(ids == null || ids.isEmpty()){
            return new ArrayList<>();
        }
        QueryWrapper<T> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id", ids);
        queryWrapper.eq(VALID_COLUMN, true);
        queryWrapper.orderByAsc("id");
        return this.list(queryWrapper);
    }

    /**
     * 简单分页查询 根据id排序
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public IPage<T> getPage(int pageNum, int pageSize) {
        QueryWrapper<T> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(VALID_COLUMN, true);
        queryWrapper.orderByAsc("id");
        return this.page(new Page<>(pageNum, pageSize), queryWrapper);
    }

    /**
     * 查询所有按id排序
     * @return
     */
    @Override
    public List<T> getAll() {
        QueryWrapper<T> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(VALID_COLUMN, true);
        queryWrapper.orderByAsc("id");
        return this.list(queryWrapper);
    }

    /**
     * 添加
     * @param t
     * @return
     */
    @Override
    public T add(T t) {
        baseMapper.insert(t);
        return t;
    }
}

