/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.web.model;

import cn.smarthse.serve.common.web.enums.StatusCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="\u63a5\u53e3\u7edf\u4e00\u8fd4\u56de\u5bf9\u8c61")
public class ResponseData<T>
implements Serializable {
    private static final long serialVersionUID = 6115763584010270155L;
    @ApiModelProperty(value="\u7ed3\u679c\u7801", required=true, example="1")
    private Integer status;
    @ApiModelProperty(value="\u63d0\u793a\u4fe1\u606f")
    private String message;
    @ApiModelProperty(value="\u7ed3\u679c\u6570\u636e")
    private T data;

    public ResponseData() {
        this.status = StatusCodeEnum.SUCCESS.getCode();
        this.message = StatusCodeEnum.SUCCESS.getMsg();
    }

    public ResponseData(T result) {
        this.status = StatusCodeEnum.SUCCESS.getCode();
        this.message = StatusCodeEnum.SUCCESS.getMsg();
        this.data = result;
    }

    private ResponseData(StatusCodeEnum codeEnum, T data) {
        this.status = codeEnum.getCode();
        this.message = codeEnum.getMsg();
        this.data = data;
    }

    public ResponseData(StatusCodeEnum codeEnum, String message) {
        this.status = codeEnum.getCode();
        this.message = message != null ? message : codeEnum.getMsg();
    }

    private ResponseData(int status, String message, T data) {
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public static <T> ResponseData<T> success() {
        return new ResponseData<T>();
    }

    public static <T> ResponseData<T> success(T data) {
        return new ResponseData<T>(StatusCodeEnum.SUCCESS, data);
    }

    public static <T> ResponseData<T> success(String message, T data) {
        return new ResponseData<T>(StatusCodeEnum.SUCCESS.getCode(), message, data);
    }

    public static <T> ResponseData<T> fail(String message) {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), message, null);
    }

    public static <T> ResponseData<T> fail(T data) {
        return new ResponseData<T>(StatusCodeEnum.FAIL.getCode(), null, data);
    }

    public static <T> ResponseData<T> fail(int code, String message, T data) {
        return new ResponseData<T>(code, message, data);
    }

    public static <T> ResponseData<T> error(String message) {
        return new ResponseData<Object>(StatusCodeEnum.ERROR.getCode(), message, null);
    }

    public static ResponseData<Object> requestError() {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR, null);
    }

    public static <T> ResponseData<T> requestError(String message) {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR.getCode(), message, null);
    }

    public static ResponseData<Object> forbiddenError() {
        return new ResponseData<Object>(StatusCodeEnum.FORBIDDEN_ERROR, null);
    }

    public static ResponseData<Object> forceOffline() {
        return new ResponseData<Object>(StatusCodeEnum.FORCE_OFFLINE, null);
    }

    public static ResponseData<Object> invalidSession() {
        return new ResponseData<Object>(StatusCodeEnum.INVALID_SESSION, null);
    }

    public static ResponseData<Object> loginFail() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u767b\u5f55\u5931\u8d25\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801", null);
    }

    public static ResponseData<Object> verCodeError() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u5931\u6548", null);
    }

    public static <T> ResponseData<T> noLogin() {
        return new ResponseData<T>(StatusCodeEnum.NO_LOGIN, null);
    }

    public static ResponseData<Object> repeatRequest() {
        return new ResponseData<Object>(StatusCodeEnum.REPEAT_REQUEST, null);
    }

    public static ResponseData<Object> loginTimeOver() {
        return new ResponseData<Object>(StatusCodeEnum.LOGIN_TIMSE_OVER, "\u5df2\u67095\u4eba\u767b\u5f55\uff0c\u76ee\u524d\u6682\u65f6\u65e0\u6cd5\u767b\u5f55");
    }

    public static ResponseData<String> ipLimit() {
        return new ResponseData<String>(StatusCodeEnum.ERROR, "ip\u9650\u5236\uff01");
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(status=" + this.getStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

