/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ZXingUtil {
    private static String codePath = "src/";
    private static Integer width = 150;
    private static Integer height = 150;

    public static String decode(String name) throws IOException, NotFoundException {
        String filepath = codePath + name + ".png";
        BufferedImage bufferedImage = ImageIO.read(new FileInputStream(filepath));
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, String> decodeHints = new HashMap<DecodeHintType, String>();
        decodeHints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        Result result = new MultiFormatReader().decode(bitmap, decodeHints);
        return result.getText();
    }

    public static String encode(String content, String name) throws WriterException, IOException {
        HashMap<EncodeHintType, String> encodeHints = new HashMap<EncodeHintType, String>();
        encodeHints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width.intValue(), height.intValue(), encodeHints);
        String filepath = codePath + name + ".png";
        Path path = FileSystems.getDefault().getPath(filepath, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"png", (Path)path);
        return codePath + name + ".png";
    }
}

