/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.springframework.util.StringUtils;

public class QRCodeUtil {
    private static Integer DEFAULT_WIDTH = 150;
    private static Integer DEFAULT_HEIGHT = 150;

    public static String crateQRCode(String content) {
        return QRCodeUtil.crateQRCode(content, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static String crateQRCode(String content, int width, int height) {
        if (!StringUtils.isEmpty((Object)content)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, 2);
            try {
                QRCodeWriter writer = new QRCodeWriter();
                BitMatrix bitMatrix = writer.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                ImageIO.write((RenderedImage)bufferedImage, "png", os);
                return new String("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

