/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.ReadingProcessor;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class PDFUtil {
    public static void createPDFFile(String htmlStr, OutputStream os) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(htmlStr.getBytes("UTF-8"));
        Document document = new Document(PageSize.A4);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            final Charset charsetName = Charset.forName("UTF-8");
            HtmlPipelineContext htmlContext = new HtmlPipelineContext((CssAppliers)new CssAppliersImpl((FontProvider)new XMLWorkerFontProvider(){

                public Font getFont(String fontname, String encoding, float size, int style) {
                    if (fontname == null) {
                        fontname = "SimSun";
                    }
                    BaseFont baseFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
                    return new Font(baseFont, size, style);
                }
            })){

                public HtmlPipelineContext clone() throws CloneNotSupportedException {
                    HtmlPipelineContext context = super.clone();
                    ImageProvider imageProvider = this.getImageProvider();
                    context.setImageProvider(imageProvider);
                    return context;
                }
            };
            htmlContext.setImageProvider((ImageProvider)new AbstractImageProvider(){
                String rootPath = PDFUtil.class.getResource("/template").getPath();

                public String getImageRootPath() {
                    return this.rootPath;
                }

                public Image retrieve(String src) {
                    if (StringUtils.isEmpty((CharSequence)src)) {
                        return null;
                    }
                    try {
                        Image image = Image.getInstance((String)new File(this.rootPath, src).toURI().toString());
                        image.setAbsolutePosition(400.0f, 400.0f);
                        if (image != null) {
                            this.store(src, image);
                            return image;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return super.retrieve(src);
                }
            });
            htmlContext.setAcceptUnknown(true).autoBookmark(true).setTagFactory(Tags.getHtmlTagProcessorFactory());
            CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);
            cssResolver.setFileRetrieve(new FileRetrieve(){

                public void processFromStream(InputStream in, ReadingProcessor processor) throws IOException {
                    try (InputStreamReader reader = new InputStreamReader(in, charsetName);){
                        int i = -1;
                        while (-1 != (i = reader.read())) {
                            processor.process(i);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void processFromHref(String href, ReadingProcessor processor) throws IOException {
                    InputStream is = PDFUtil.class.getResourceAsStream("/" + href);
                    try (InputStreamReader reader = new InputStreamReader(is, charsetName);){
                        int i = -1;
                        while (-1 != (i = reader.read())) {
                            processor.process(i);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            htmlContext.setAcceptUnknown(true).autoBookmark(true).setTagFactory(Tags.getHtmlTagProcessorFactory()).setResourcesRootPath(null);
            HtmlPipeline htmlPipeline = new HtmlPipeline(htmlContext, (Pipeline)new PdfWriterPipeline(document, writer));
            CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, (Pipeline)htmlPipeline);
            htmlContext.setAcceptUnknown(true).autoBookmark(true).setTagFactory(Tags.getHtmlTagProcessorFactory()).setResourcesRootPath(null);
            XMLWorker worker = new XMLWorker((Pipeline)pipeline, true);
            XMLParser p = new XMLParser(true, (XMLParserListener)worker, Charset.forName("UTF-8"));
            p.parse((InputStream)bais, Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                document.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                bais.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

